/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.MarkMode;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ILittleTile {
    public boolean hasLittlePreview(ItemStack var1);

    public LittlePreviews getLittlePreview(ItemStack var1);

    default public LittlePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution, boolean marked) {
        return this.getLittlePreview(stack);
    }

    public void saveLittlePreview(ItemStack var1, LittlePreviews var2);

    default public void rotateLittlePreview(EntityPlayer player, ItemStack stack, Rotation rotation) {
        LittlePreviews previews = this.getLittlePreview(stack, false, false);
        if (previews.isEmpty()) {
            return;
        }
        previews.rotatePreviews(rotation, previews.getContext().rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    default public void flipLittlePreview(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis) {
        LittlePreviews previews = this.getLittlePreview(stack, false, false);
        if (previews.isEmpty()) {
            return;
        }
        previews.flipPreviews(axis, previews.getContext().rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    default public boolean sendTransformationUpdate() {
        return true;
    }

    default public LittleGridContext getPreviewsContext(ItemStack stack) {
        if (stack.func_77942_o()) {
            return LittleGridContext.get(stack.func_77978_p());
        }
        return LittleGridContext.get();
    }

    @SideOnly(value=Side.CLIENT)
    default public LittleGridContext getPositionContext(ItemStack stack) {
        return LittleGridContext.get();
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onRightClick(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void onDeselect(EntityPlayer player, ItemStack stack) {
    }

    public boolean containsIngredients(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    default public void onClickAir(EntityPlayer player, ItemStack stack) {
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onClickBlock(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onMouseWheelClickBlock(World world, EntityPlayer player, ItemStack stack, RayTraceResult result) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public float getPreviewAlphaFactor() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldCache() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void tickPreview(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
    }

    default public PlacementMode getPlacementMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return PlacementMode.getModeOrDefault(stack.func_77978_p().func_74779_i("mode"));
        }
        return PlacementMode.getDefault();
    }

    @SideOnly(value=Side.CLIENT)
    default public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return null;
    }

    default public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    default public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return null;
    }

    default public SubContainerConfigure getConfigureContainerAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    default public MarkMode onMark(EntityPlayer player, ItemStack stack) {
        return new MarkMode();
    }

    default public boolean snapToGridByDefault() {
        return false;
    }

    default public LittleVec getCachedSize(ItemStack stack) {
        return null;
    }

    default public LittleVec getCachedOffset(ItemStack stack) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    default public List<LittleRenderBox> getPositingCubes(World world, BlockPos pos, ItemStack stack) {
        LittleStructureType type;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure") && (type = LittleStructureRegistry.getStructureType(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"))) != null) {
            return type.getPositingCubes(world, pos, stack);
        }
        return null;
    }
}

