/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.CreativeModelPipeline;
import com.creativemd.creativecore.common.utils.type.SingletonList;
import com.creativemd.creativecore.common.world.IBlockAccessFake;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.api.IFakeRenderingBlock;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBoxCache;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBufferCache;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.client.render.world.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.world.RenderUtils;
import com.creativemd.littletiles.client.render.world.TileEntityRenderManager;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.event.LittleEventHandler;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.shaders.SVertexBuilder;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class RenderingThread
extends Thread {
    private static final String[] fakeWorldMods = new String[]{"chisel"};
    public static List<RenderingThread> threads;
    private static int threadIndex;
    public static final HashMap<Object, Integer> chunks;
    public static Minecraft mc;
    public ConcurrentLinkedQueue<RenderingData> updateCoords = new ConcurrentLinkedQueue();
    final int index;
    private final SingletonList<BakedQuad> bakedQuadWrapper = new SingletonList(null);
    private final IBlockAccessFake fakeAccess = new IBlockAccessFake();
    public boolean active = true;
    public static final Field compileTaskField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RenderingThread getNextThread() {
        List<RenderingThread> list = threads;
        synchronized (list) {
            RenderingThread thread = threads.get(threadIndex);
            if (thread == null) {
                thread = new RenderingThread(threadIndex);
                threads.set(threadIndex, thread);
            }
            if (++threadIndex >= threads.size()) {
                threadIndex = 0;
            }
            return thread;
        }
    }

    public static void initThreads(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count has to be at least equal or greater than one");
        }
        if (threads != null) {
            for (RenderingThread thread : threads) {
                if (thread == null) continue;
                thread.interrupt();
            }
            for (RenderingThread thread : threads) {
                while (thread != null && thread.updateCoords.size() > 0) {
                    thread.updateCoords.poll().te.render.resetRenderingState();
                }
            }
        }
        threadIndex = 0;
        threads = new ArrayList<RenderingThread>();
        for (int i = 0; i < count; ++i) {
            threads.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addCoordToUpdate(TileEntityLittleTiles te) {
        RenderingThread renderer = RenderingThread.getNextThread();
        Object chunk = te.func_145831_w() instanceof IOrientatedWorld ? RenderUtils.getRenderChunk((IOrientatedWorld)te.func_145831_w(), te.func_174877_v()) : RenderUtils.getRenderChunk(RenderUtils.getViewFrustum(), te.func_174877_v());
        if (chunk == null) {
            System.out.println("Invalid tileentity with no rendering chunk! pos: " + te.func_174877_v() + ", world: " + te.func_145831_w());
            return false;
        }
        if (te.isRenderingEmpty()) {
            int index = te.render.startBuildingCache();
            te.render.getBoxCache().clear();
            TileEntityRenderManager tileEntityRenderManager = te.render;
            synchronized (tileEntityRenderManager) {
                te.render.getBufferCache().setEmpty();
            }
            if (!te.render.finishBuildingCache(index, LittleChunkDispatcher.currentRenderState, true)) {
                return RenderingThread.addCoordToUpdate(te);
            }
            return false;
        }
        HashMap<Object, Integer> hashMap = chunks;
        synchronized (hashMap) {
            Integer count = chunks.get(chunk);
            if (count == null) {
                count = 0;
            }
            chunks.put(chunk, count + 1);
        }
        renderer.updateCoords.add(new RenderingData(te, chunk));
        return true;
    }

    public RenderingThread(int index) {
        this.index = index;
        this.start();
    }

    public int getThreadIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.active) {
                WorldClient world = RenderingThread.mc.field_71441_e;
                long duration = 0L;
                if (world != null && !this.updateCoords.isEmpty()) {
                    RenderingData data = this.updateCoords.poll();
                    try {
                        if (LittleTilesProfilerOverlay.isActive()) {
                            duration = System.nanoTime();
                        }
                        if (data.te.func_145837_r()) {
                            throw new InvalidTileEntityException(data.te.func_174877_v() + "");
                        }
                        data.index = data.te.render.startBuildingCache();
                        BlockPos pos = data.te.func_174877_v();
                        LayeredRenderBoxCache cubeCache = data.te.render.getBoxCache();
                        if (cubeCache == null) {
                            throw new InvalidTileEntityException(data.te.func_174877_v() + "");
                        }
                        if (data.te.func_145831_w() == null || !data.te.hasLoaded()) {
                            throw new RenderingException("Tileentity is not loaded yet");
                        }
                        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                            cubeCache.set(BlockTile.getRenderingCubes(data.state, (TileEntity)data.te, null, layer), layer);
                            List<LittleRenderBox> cubes = cubeCache.get(layer);
                            for (int j = 0; j < cubes.size(); ++j) {
                                RenderBox cube = cubes.get(j);
                                if (!cube.doesNeedQuadUpdate) continue;
                                if (ArrayUtils.contains((Object[])fakeWorldMods, (Object)cube.block.getRegistryName().func_110624_b())) {
                                    this.fakeAccess.set((IBlockAccess)data.te.func_145831_w(), pos, cube.getBlockState());
                                    world = this.fakeAccess;
                                } else {
                                    world = data.te.func_145831_w();
                                }
                                IBlockState modelState = cube.getBlockState().func_185899_b((IBlockAccess)world, pos);
                                IBakedModel blockModel = OptifineHelper.getRenderModel((IBakedModel)mc.func_175602_ab().func_184389_a(modelState), (IBlockAccess)world, (IBlockState)modelState, (BlockPos)pos);
                                modelState = cube.getModelState(modelState, (IBlockAccess)world, pos);
                                BlockPos offset = cube.getOffset();
                                for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                    EnumFacing facing = EnumFacing.field_82609_l[h];
                                    if (cube.renderSide(facing)) {
                                        if (cube.getQuad(facing) != null) continue;
                                        cube.setQuad(facing, CreativeBakedModel.getBakedQuad((IBlockAccess)world, (RenderBox)cube, (BlockPos)pos, (BlockPos)offset, (IBlockState)modelState, (IBakedModel)blockModel, (BlockRenderLayer)layer, (EnumFacing)facing, (long)MathHelper.func_180186_a((Vec3i)pos), (boolean)false));
                                        continue;
                                    }
                                    cube.setQuad(facing, null);
                                }
                                cube.doesNeedQuadUpdate = false;
                            }
                        }
                        cubeCache.sort();
                        this.fakeAccess.set(null, null, null);
                        if (data.te.func_145837_r()) {
                            throw new InvalidTileEntityException(data.te.func_174877_v() + "");
                        }
                        world = RenderingThread.mc.field_71441_e;
                        int renderState = LittleChunkDispatcher.currentRenderState;
                        LayeredRenderBufferCache layerBuffer = data.te.render.getBufferCache();
                        VertexFormat format = DefaultVertexFormats.field_176600_a;
                        try {
                            World renderWorld = data.te.func_145831_w();
                            if (renderWorld instanceof SubWorld && !((SubWorld)renderWorld).shouldRender) {
                                renderWorld = ((SubWorld)renderWorld).getRealWorld();
                            }
                            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                                BlockRenderLayer layer = BlockRenderLayer.values()[i];
                                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                                List<LittleRenderBox> cubes = cubeCache.get(layer);
                                BufferBuilder buffer = null;
                                if (cubes != null && cubes.size() > 0) {
                                    buffer = LayeredRenderBufferCache.createVertexBuffer(format, cubes);
                                }
                                if (buffer != null) {
                                    buffer.func_181668_a(7, format);
                                    if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isRenderRegions() && !data.subWorld) {
                                        int bits = 8;
                                        RenderChunk chunk = (RenderChunk)data.chunk;
                                        int dx = chunk.func_178568_j().func_177958_n() >> bits << bits;
                                        int dy = chunk.func_178568_j().func_177956_o() >> bits << bits;
                                        int dz = chunk.func_178568_j().func_177952_p() >> bits << bits;
                                        dx = OptifineHelper.getRenderChunkRegionX((RenderChunk)chunk);
                                        dz = OptifineHelper.getRenderChunkRegionZ((RenderChunk)chunk);
                                        buffer.func_178969_c((double)(-dx), (double)(-dy), (double)(-dz));
                                    } else {
                                        int chunkX = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
                                        int chunkY = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
                                        int chunkZ = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
                                        buffer.func_178969_c((double)(-chunkX * 16), (double)(-chunkY * 16), (double)(-chunkZ * 16));
                                    }
                                    boolean smooth = Minecraft.func_71379_u() && data.state.getLightValue((IBlockAccess)renderWorld, pos) == 0;
                                    BitSet bitset = null;
                                    float[] afloat = null;
                                    Object ambientFace = null;
                                    if (FMLClientHandler.instance().hasOptifine()) {
                                        ambientFace = OptifineHelper.getEnv((BufferBuilder)buffer, (IBlockAccess)renderWorld, (IBlockState)data.state, (BlockPos)pos);
                                    } else if (smooth) {
                                        bitset = new BitSet(3);
                                        afloat = new float[EnumFacing.field_82609_l.length * 2];
                                        ambientFace = CreativeModelPipeline.createAmbientOcclusionFace();
                                    }
                                    for (int j = 0; j < cubes.size(); ++j) {
                                        RenderBox cube = cubes.get(j);
                                        IBlockState state = cube.getBlockState();
                                        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                            if (state.func_177230_c() instanceof IFakeRenderingBlock) {
                                                state = ((IFakeRenderingBlock)state.func_177230_c()).getFakeState(state);
                                            }
                                            SVertexBuilder.pushEntity((IBlockState)state, (BlockPos)pos, (IBlockAccess)data.te.func_145831_w(), (BufferBuilder)buffer);
                                        }
                                        for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                            EnumFacing facing = EnumFacing.field_82609_l[h];
                                            Object quadObject = cube.getQuad(facing);
                                            SingletonList<BakedQuad> quads = null;
                                            if (quadObject instanceof List) {
                                                quads = (SingletonList<BakedQuad>)quadObject;
                                            } else if (quadObject instanceof BakedQuad) {
                                                this.bakedQuadWrapper.setElement((Object)((BakedQuad)quadObject));
                                                quads = this.bakedQuadWrapper;
                                            }
                                            if (quads == null || quads.isEmpty()) continue;
                                            if (smooth) {
                                                CreativeModelPipeline.renderBlockFaceSmooth((IBlockAccess)renderWorld, (IBlockState)state, (BlockPos)pos, (BufferBuilder)buffer, (BlockRenderLayer)layer, quads, (float[])afloat, (EnumFacing)facing, (BitSet)bitset, (Object)ambientFace, (RenderBox)cube);
                                                continue;
                                            }
                                            CreativeModelPipeline.renderBlockFaceFlat((IBlockAccess)renderWorld, (IBlockState)state, (BlockPos)pos, (BufferBuilder)buffer, (BlockRenderLayer)layer, quads, (EnumFacing)facing, (BitSet)bitset, (RenderBox)cube, (Object)ambientFace);
                                        }
                                        this.bakedQuadWrapper.setElement(null);
                                        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                            SVertexBuilder.popEntity((BufferBuilder)buffer);
                                        }
                                        if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                                        cube.deleteQuadCache();
                                    }
                                    if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                        SVertexBuilder.calcNormalChunkLayer((BufferBuilder)buffer);
                                    }
                                    buffer.func_178977_d();
                                    TileEntityRenderManager tileEntityRenderManager = data.te.render;
                                    synchronized (tileEntityRenderManager) {
                                        layerBuffer.set(layer.ordinal(), buffer);
                                        continue;
                                    }
                                }
                                TileEntityRenderManager tileEntityRenderManager = data.te.render;
                                synchronized (tileEntityRenderManager) {
                                    layerBuffer.set(layer.ordinal(), null);
                                    continue;
                                }
                            }
                            ForgeHooksClient.setRenderLayer(null);
                            if (!LittleTiles.CONFIG.rendering.useCubeCache) {
                                cubeCache.clear();
                            }
                            if (!RenderingThread.finish(data, renderState, false)) {
                                this.updateCoords.add(data);
                            }
                            if (LittleTilesProfilerOverlay.isActive()) {
                                LittleTilesProfilerOverlay.finishBuildingCache(System.nanoTime() - duration);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!RenderingThread.finish(data, -1, false)) {
                                this.updateCoords.add(data);
                            }
                        }
                    }
                    catch (InvalidTileEntityException e) {
                        RenderingThread.finish(data, -1, true);
                    }
                    catch (Exception e) {
                        if (!(e instanceof RenderingException)) {
                            e.printStackTrace();
                        }
                    }
                    catch (OutOfMemoryError error) {
                        this.updateCoords.add(data);
                        error.printStackTrace();
                    }
                    data = null;
                } else if (!(world != null || this.updateCoords.isEmpty() && chunks.isEmpty())) {
                    this.updateCoords.clear();
                    chunks.clear();
                }
                if (this.updateCoords.isEmpty()) {
                    RenderingThread.sleep(1L);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean finish(RenderingData data, int renderState, boolean force) {
        if (!data.te.render.finishBuildingCache(data.index, renderState, force)) {
            return false;
        }
        boolean complete = false;
        HashMap<Object, Integer> hashMap = chunks;
        synchronized (hashMap) {
            Integer count = chunks.get(data.chunk);
            if (count != null) {
                if (count <= 1) {
                    chunks.remove(data.chunk);
                    complete = true;
                } else {
                    chunks.put(data.chunk, count - 1);
                }
            }
        }
        if (data.subWorld) {
            ((LittleRenderChunk)data.chunk).addRenderData(data.te);
        }
        if (complete) {
            if (data.subWorld) {
                ++LittleTilesProfilerOverlay.ltChunksUpdates;
                ((LittleRenderChunk)data.chunk).markCompleted();
            } else {
                ++LittleTilesProfilerOverlay.vanillaChunksUpdates;
                RenderingThread.markRenderUpdate((RenderChunk)data.chunk);
            }
        }
        return true;
    }

    public static void markRenderUpdate(RenderChunk chunk) {
        try {
            chunk.func_178579_c().lock();
            if (RenderingThread.isChunkCurrentlyUpdating(chunk)) {
                LittleEventHandler.queueChunkUpdate(chunk);
            } else {
                chunk.func_178575_a(false);
            }
        }
        finally {
            chunk.func_178579_c().unlock();
        }
    }

    public static boolean isChunkCurrentlyUpdating(RenderChunk chunk) {
        try {
            ChunkCompileTaskGenerator compileTask = (ChunkCompileTaskGenerator)compileTaskField.get(chunk);
            return chunk.func_178569_m() || compileTask != null && compileTask.func_178538_g() == ChunkCompileTaskGenerator.Type.REBUILD_CHUNK && (compileTask.func_178546_a() != ChunkCompileTaskGenerator.Status.COMPILING || compileTask.func_178546_a() != ChunkCompileTaskGenerator.Status.UPLOADING);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        chunks = new HashMap();
        mc = Minecraft.func_71410_x();
        RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
        compileTaskField = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"compileTask", "field_178599_i"});
    }

    private static class RenderingData {
        public final TileEntityLittleTiles te;
        public final IBlockState state;
        public final Object chunk;
        public final boolean subWorld;
        public int index;

        public RenderingData(TileEntityLittleTiles te, Object chunk) {
            this.te = te;
            this.state = te.getBlockTileState();
            this.chunk = chunk;
            this.subWorld = !(chunk instanceof RenderChunk);
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }

    public static class InvalidTileEntityException
    extends Exception {
        public InvalidTileEntityException(String arg0) {
            super(arg0);
        }
    }
}

