/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.event;

import com.creativemd.littletiles.client.event.HoldLeftClick;
import com.creativemd.littletiles.client.event.LeftClick;
import com.creativemd.littletiles.client.event.PickBlockEvent;
import com.creativemd.littletiles.client.event.WheelClick;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final Method sendClickBlockToControllerMethod = ReflectionHelper.findMethod(Minecraft.class, (String)"sendClickBlockToController", (String)"func_147115_a", (Class[])new Class[]{Boolean.TYPE});

    @SideOnly(value=Side.CLIENT)
    public static void onHoldClick(boolean leftClick) {
        try {
            HoldLeftClick event = new HoldLeftClick((World)InputEventHandler.mc.field_71441_e, (EntityPlayer)InputEventHandler.mc.field_71439_g, leftClick);
            MinecraftForge.EVENT_BUS.post((Event)event);
            sendClickBlockToControllerMethod.invoke((Object)mc, event.getLeftClickResult());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean onMouseClick(RayTraceResult result, EntityPlayer player, World world) {
        LeftClick event = new LeftClick(world, player, result);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean onMouseWheelClick(EntityPlayer player, World world) {
        WheelClick event = new WheelClick(world, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean onPickBlock(RayTraceResult result, EntityPlayer player, World world) {
        PickBlockEvent event = new PickBlockEvent(world, player, result);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled();
    }
}

