/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.startup.UniqueItemStackListBuilder;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper
implements IStackHelper {
    private final ISubtypeRegistry subtypeRegistry;
    private final Map<UidMode, Map<ItemStack, String>> uidCache = new EnumMap<UidMode, Map<ItemStack, String>>(UidMode.class);
    private boolean uidCacheEnabled = true;

    public StackHelper(ISubtypeRegistry subtypeRegistry) {
        this.subtypeRegistry = subtypeRegistry;
        for (UidMode mode : UidMode.values()) {
            this.uidCache.put(mode, (Map<ItemStack, String>)new Reference2ObjectOpenHashMap());
        }
    }

    public void enableUidCache() {
        this.uidCacheEnabled = true;
    }

    public void disableUidCache() {
        for (UidMode mode : UidMode.values()) {
            this.uidCache.put(mode, (Map<ItemStack, String>)new Reference2ObjectOpenHashMap());
        }
        this.uidCacheEnabled = false;
    }

    @Nullable
    public String getOreDictEquivalent(Collection<ItemStack> itemStacks) {
        if (itemStacks.size() < 2) {
            return null;
        }
        ItemStack firstStack = itemStacks.iterator().next();
        if (firstStack != null) {
            for (int oreId : OreDictionary.getOreIDs((ItemStack)firstStack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                Object ores = OreDictionary.getOres((String)oreName);
                if (!this.containsSameStacks(itemStacks, (Collection<ItemStack>)(ores = this.getAllSubtypes((Iterable)ores)))) continue;
                return oreName;
            }
        }
        return null;
    }

    public MatchingItemsResult getMatchingItems(Map<Integer, ItemStack> availableItemStacks, Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredientsMap) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        int recipeSlotNumber = -1;
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            IGuiIngredient<ItemStack> ingredient = ingredientsMap.get(key);
            if (!ingredient.isInput()) continue;
            ++recipeSlotNumber;
            List<ItemStack> requiredStacks = ingredient.getAllIngredients();
            if (requiredStacks.isEmpty()) continue;
            Integer matching = this.containsAnyStackIndexed(availableItemStacks, requiredStacks);
            if (matching == null) {
                matchingItemResult.missingItems.add(key);
                continue;
            }
            ItemStack matchingStack = availableItemStacks.get(matching);
            matchingStack.func_190918_g(1);
            if (matchingStack.func_190916_E() == 0) {
                availableItemStacks.remove(matching);
            }
            matchingItemResult.matchingItems.put(recipeSlotNumber, matching);
        }
        return matchingItemResult;
    }

    public boolean containsSameStacks(Collection<ItemStack> stacks, Collection<ItemStack> contains) {
        return this.containsSameStacks(new MatchingIterable(stacks), new MatchingIterable(contains));
    }

    public <R> boolean containsSameStacks(Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<R>> contains) {
        for (ItemStackMatchable<R> stack : contains) {
            if (this.containsStack(stacks, stack) != null) continue;
            return false;
        }
        for (ItemStackMatchable<R> stack : stacks) {
            if (this.containsStack(contains, stack) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Integer containsAnyStackIndexed(Map<Integer, ItemStack> stacks, Iterable<ItemStack> contains) {
        MatchingIndexed matchingStacks = new MatchingIndexed(stacks);
        MatchingIterable matchingContains = new MatchingIterable(contains);
        return this.containsStackMatchable(matchingStacks, matchingContains);
    }

    @Nullable
    public ItemStack containsStack(Iterable<ItemStack> stacks, ItemStack contains) {
        List<ItemStack> containsList = Collections.singletonList(contains);
        return this.containsAnyStack(stacks, containsList);
    }

    @Override
    @Nullable
    public ItemStack containsAnyStack(Iterable<ItemStack> stacks, Iterable<ItemStack> contains) {
        ErrorUtil.checkNotNull(stacks, "stacks");
        ErrorUtil.checkNotNull(contains, "contains");
        MatchingIterable matchingStacks = new MatchingIterable(stacks);
        MatchingIterable matchingContains = new MatchingIterable(contains);
        return this.containsStackMatchable(matchingStacks, matchingContains);
    }

    @Nullable
    public <R, T> R containsStackMatchable(Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = this.containsStack(stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public <R> R containsStack(Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!this.isEquivalent(contains.getStack(), stack.getStack())) continue;
            return stack.getResult();
        }
        return null;
    }

    @Override
    public boolean isEquivalent(@Nullable ItemStack lhs, @Nullable ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        String keyLhs = this.getUniqueIdentifierForStack(lhs, UidMode.NORMAL);
        String keyRhs = this.getUniqueIdentifierForStack(rhs, UidMode.NORMAL);
        return keyLhs.equals(keyRhs);
    }

    public List<ItemStack> getMatchingStacks(Ingredient ingredient) {
        if (ingredient == Ingredient.field_193370_a) {
            return Collections.emptyList();
        }
        ItemStack[] matchingStacks = ingredient.func_193365_a();
        if (matchingStacks == null) {
            return Collections.emptyList();
        }
        if (matchingStacks.length > 0) {
            return Arrays.asList(matchingStacks);
        }
        return this.getAllSubtypes(Arrays.asList(ingredient.field_193371_b));
    }

    @Override
    public List<ItemStack> getSubtypes(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return Collections.emptyList();
        }
        if (itemStack.func_77952_i() != Short.MAX_VALUE) {
            return Collections.singletonList(itemStack);
        }
        NonNullList subtypes = NonNullList.func_191196_a();
        this.addSubtypesToList((List<ItemStack>)subtypes, itemStack);
        return subtypes;
    }

    private void addSubtypesToList(List<ItemStack> subtypeList, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int stackSize = itemStack.func_190916_E();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            if (itemTab == null) {
                ItemStack copy = itemStack.func_77946_l();
                copy.func_77964_b(0);
                subtypeList.add(copy);
                continue;
            }
            this.addSubtypesFromCreativeTabToList(subtypeList, item, stackSize, itemTab);
        }
    }

    public void addSubtypesToList(List<ItemStack> subtypeList, Item item) {
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            if (itemTab == null) {
                subtypeList.add(new ItemStack(item, 1));
                continue;
            }
            this.addSubtypesFromCreativeTabToList(subtypeList, item, 1, itemTab);
        }
    }

    private void addSubtypesFromCreativeTabToList(List<ItemStack> subtypeList, Item item, int stackSize, CreativeTabs itemTab) {
        NonNullList subItems = NonNullList.func_191196_a();
        try {
            item.func_150895_a(itemTab, subItems);
        }
        catch (LinkageError | RuntimeException e) {
            Log.get().warn("Caught a crash while getting sub-items of {}", (Object)item, (Object)e);
        }
        for (ItemStack subItem : subItems) {
            if (subItem.func_190926_b()) {
                Log.get().warn("Found an empty subItem of {}", (Object)item);
                continue;
            }
            if (subItem.func_77960_j() == Short.MAX_VALUE) {
                String itemStackInfo = ErrorUtil.getItemStackInfo(subItem);
                Log.get().error("Found an subItem of {} with wildcard metadata: {}", (Object)item, (Object)itemStackInfo);
                continue;
            }
            if (subItem.func_190916_E() != stackSize) {
                ItemStack subItemCopy = subItem.func_77946_l();
                subItemCopy.func_190920_e(stackSize);
                subtypeList.add(subItemCopy);
                continue;
            }
            subtypeList.add(subItem);
        }
    }

    @Override
    public List<ItemStack> getAllSubtypes(@Nullable Iterable stacks) {
        if (stacks == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> allSubtypes = new ArrayList<ItemStack>();
        this.addSubtypesToList(allSubtypes, stacks);
        if (StackHelper.isAllNulls(allSubtypes)) {
            return Collections.emptyList();
        }
        return allSubtypes;
    }

    private static boolean isAllNulls(Iterable<?> iterable) {
        for (Object element : iterable) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    private void addSubtypesToList(List<ItemStack> subtypesList, Iterable stacks) {
        for (Object obj : stacks) {
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                if (itemStack.func_190926_b()) continue;
                if (itemStack.func_77952_i() == Short.MAX_VALUE) {
                    this.addSubtypesToList(subtypesList, itemStack);
                    continue;
                }
                subtypesList.add(itemStack);
                continue;
            }
            if (obj instanceof Iterable) {
                this.addSubtypesToList(subtypesList, (Iterable)obj);
                continue;
            }
            if (obj != null) {
                Log.get().error("Unknown object found: {}", obj);
                continue;
            }
            subtypesList.add(null);
        }
    }

    @Override
    public List<List<ItemStack>> expandRecipeItemStackInputs(@Nullable List inputs) {
        if (inputs == null) {
            return Collections.emptyList();
        }
        return this.expandRecipeItemStackInputs(inputs, true);
    }

    public List<List<ItemStack>> expandRecipeItemStackInputs(List inputs, boolean expandSubtypes) {
        ArrayList<List<ItemStack>> expandedInputs = new ArrayList<List<ItemStack>>();
        for (Object input : inputs) {
            NonNullList<ItemStack> expandedInput = this.toItemStackList(input, expandSubtypes);
            expandedInputs.add((List<ItemStack>)expandedInput);
        }
        return expandedInputs;
    }

    public NonNullList<ItemStack> toItemStackList(@Nullable Object stacks) {
        if (stacks == null) {
            return NonNullList.func_191196_a();
        }
        return this.toItemStackList(stacks, true);
    }

    public NonNullList<ItemStack> toItemStackList(Object stacks, boolean expandSubtypes) {
        UniqueItemStackListBuilder itemStackListBuilder = new UniqueItemStackListBuilder(this);
        this.toItemStackList(itemStackListBuilder, stacks, expandSubtypes);
        return itemStackListBuilder.build();
    }

    private void toItemStackList(UniqueItemStackListBuilder itemStackListBuilder, @Nullable Object input, boolean expandSubtypes) {
        if (input instanceof ItemStack) {
            this.toItemStackList(itemStackListBuilder, (ItemStack)input, expandSubtypes);
        } else if (input instanceof String) {
            NonNullList stacks = OreDictionary.getOres((String)((String)input));
            for (ItemStack stack : stacks) {
                this.toItemStackList(itemStackListBuilder, stack, expandSubtypes);
            }
        } else if (input instanceof Ingredient) {
            List<ItemStack> stacks = this.getMatchingStacks((Ingredient)input);
            for (ItemStack stack : stacks) {
                this.toItemStackList(itemStackListBuilder, stack, expandSubtypes);
            }
        } else if (input instanceof Iterable) {
            for (Object obj : (Iterable)input) {
                this.toItemStackList(itemStackListBuilder, obj, expandSubtypes);
            }
        } else if (input != null) {
            Log.get().error("Unknown object found: {}", input);
        }
    }

    private void toItemStackList(UniqueItemStackListBuilder itemStackListBuilder, @Nullable ItemStack itemStack, boolean expandSubtypes) {
        if (itemStack != null) {
            if (expandSubtypes && itemStack.func_77960_j() == Short.MAX_VALUE) {
                List<ItemStack> subtypes = this.getSubtypes(itemStack);
                for (ItemStack subtype : subtypes) {
                    itemStackListBuilder.add(subtype);
                }
            } else {
                itemStackListBuilder.add(itemStack);
            }
        }
    }

    public String getUniqueIdentifierForStack(ItemStack stack) {
        return this.getUniqueIdentifierForStack(stack, UidMode.NORMAL);
    }

    public String getUniqueIdentifierForStack(ItemStack stack, UidMode mode) {
        String result;
        ErrorUtil.checkNotEmpty(stack, "stack");
        if (this.uidCacheEnabled && (result = this.uidCache.get((Object)mode).get(stack)) != null) {
            return result;
        }
        Item item = stack.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            throw new IllegalStateException("Item has no registry name: " + stackInfo);
        }
        StringBuilder itemKey = new StringBuilder(itemName.toString());
        int metadata = stack.func_77960_j();
        if (mode != UidMode.WILDCARD && metadata != Short.MAX_VALUE) {
            String subtypeInfo = this.subtypeRegistry.getSubtypeInfo(stack);
            if (subtypeInfo != null) {
                if (!subtypeInfo.isEmpty()) {
                    itemKey.append(':').append(subtypeInfo);
                }
            } else if (mode == UidMode.FULL) {
                NBTTagCompound forgeCaps;
                itemKey.append(':').append(metadata);
                NBTTagCompound serializedNbt = stack.serializeNBT();
                NBTTagCompound nbtTagCompound = serializedNbt.func_74775_l("tag").func_74737_b();
                if (serializedNbt.func_74764_b("ForgeCaps") && !(forgeCaps = serializedNbt.func_74775_l("ForgeCaps")).func_82582_d()) {
                    nbtTagCompound.func_74782_a("ForgeCaps", (NBTBase)forgeCaps);
                }
                if (!nbtTagCompound.func_82582_d()) {
                    itemKey.append(':').append(nbtTagCompound);
                }
            } else if (stack.func_77981_g()) {
                itemKey.append(':').append(metadata);
            }
        }
        String result2 = itemKey.toString();
        if (this.uidCacheEnabled) {
            this.uidCache.get((Object)mode).put(stack, result2);
        }
        return result2;
    }

    private static class MatchingIndexed
    implements Iterable<ItemStackMatchable<Integer>> {
        private final Map<Integer, ItemStack> map;

        public MatchingIndexed(Map<Integer, ItemStack> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Integer>> iterator() {
            return new DelegateIterator<Map.Entry<Integer, ItemStack>, ItemStackMatchable<Integer>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Integer> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Integer>(){

                        @Override
                        public ItemStack getStack() {
                            return (ItemStack)entry.getValue();
                        }

                        @Override
                        public Integer getResult() {
                            return (Integer)entry.getKey();
                        }
                    };
                }
            };
        }
    }

    private static class MatchingIterable
    implements Iterable<ItemStackMatchable<ItemStack>> {
        private final Iterable<ItemStack> list;

        public MatchingIterable(Iterable<ItemStack> list) {
            this.list = list;
        }

        @Override
        public Iterator<ItemStackMatchable<ItemStack>> iterator() {
            Iterator<ItemStack> stacks = this.list.iterator();
            return new DelegateIterator<ItemStack, ItemStackMatchable<ItemStack>>(stacks){

                @Override
                public ItemStackMatchable<ItemStack> next() {
                    final ItemStack stack = (ItemStack)this.delegate.next();
                    return new ItemStackMatchable<ItemStack>(){

                        @Override
                        @Nullable
                        public ItemStack getStack() {
                            return stack;
                        }

                        @Override
                        @Nullable
                        public ItemStack getResult() {
                            return stack;
                        }
                    };
                }
            };
        }
    }

    private static abstract class DelegateIterator<T, R>
    implements Iterator<R> {
        protected final Iterator<T> delegate;

        public DelegateIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    private static interface ItemStackMatchable<R> {
        @Nullable
        public ItemStack getStack();

        @Nullable
        public R getResult();
    }

    public static class MatchingItemsResult {
        public final Map<Integer, Integer> matchingItems = new Int2IntOpenHashMap();
        public final Int2IntMap matchingItemsCasted = (Int2IntMap)this.matchingItems;
        public final List<Integer> missingItems = new IntArrayList();
    }

    public static enum UidMode {
        NORMAL,
        WILDCARD,
        FULL;

    }
}

