/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.unification.properties;

import com.google.common.base.Preconditions;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;

public class AlloyBlastProperty
implements IMaterialProperty<AlloyBlastProperty> {
    private Fluid fluid;
    private int temperature;

    public AlloyBlastProperty(int temperature) {
        this.temperature = temperature;
    }

    public void verifyProperty(MaterialProperties materialProperties) {
        materialProperties.ensureSet(PropertyKey.BLAST);
        materialProperties.ensureSet(PropertyKey.FLUID);
        this.temperature = ((BlastProperty)materialProperties.getProperty(PropertyKey.BLAST)).getBlastTemperature();
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void setFluid(@Nonnull Fluid materialFluid) {
        Preconditions.checkNotNull((Object)materialFluid);
        this.fluid = materialFluid;
    }

    public void setTemperature(int fluidTemperature) {
        Preconditions.checkArgument((fluidTemperature > 0 ? 1 : 0) != 0, (Object)"Invalid temperature");
        this.temperature = fluidTemperature;
    }

    public int getTemperature() {
        return this.temperature;
    }
}

