/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.featuredserver;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.alwa.featuredserver.ServerDataHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="featuredservers", name="FeaturedServers", version="1.12-1.0.6", clientSideOnly=true, acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class FeaturedServers {
    public static final String MODID = "featuredservers";
    public static final String NAME = "FeaturedServers";
    private static Logger logger;
    private FileReader serversFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        File serverList;
        logger = event.getModLog();
        File configFolder = new File(event.getModConfigurationDirectory(), NAME);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(serverList = new File(configFolder, "featuredservers.json")).exists()) {
            serverList.createNewFile();
            FileWriter writer = new FileWriter(serverList);
            writer.write("[\n  {\n    \"serverName\": \"Featured Server\",\n    \"serverIP\": \"127.0.0.1\"\n  },\n  {\n    \"serverName\": \"Another Server!\",\n    \"serverIP\": \"192.168.1.1\"\n  }\n]");
            writer.close();
        }
        this.serversFile = new FileReader(serverList.getPath());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Gson gson = new Gson();
        JsonReader reader = new JsonReader((Reader)this.serversFile);
        ServerDataHelper[] featuredList = (ServerDataHelper[])gson.fromJson(reader, ServerDataHelper[].class);
        if (featuredList != null) {
            ServerList serverList = new ServerList(Minecraft.func_71410_x());
            try {
                for (ServerDataHelper serverhelp : featuredList) {
                    ServerData server = new ServerData(serverhelp.serverName, serverhelp.serverIP, false);
                    if (FeaturedServers.inList(server, serverList).booleanValue()) {
                        logger.log(Level.INFO, "Featured server already in server list");
                        continue;
                    }
                    logger.log(Level.INFO, "Adding featured server");
                    serverList.func_78849_a(server);
                    serverList.func_78855_b();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Boolean inList(ServerData server, ServerList list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.func_78856_c(); ++i) {
            ServerData serverData = list.func_78850_a(i);
            if (serverData.field_78847_a == null || serverData.field_78845_b == null || !serverData.field_78847_a.equalsIgnoreCase(server.field_78847_a) || !serverData.field_78845_b.equalsIgnoreCase(server.field_78845_b)) continue;
            return true;
        }
        return false;
    }
}

