/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.TicketKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class FTBUtilitiesLoadedChunkManager
implements ForgeChunkManager.LoadingCallback {
    public static final FTBUtilitiesLoadedChunkManager INSTANCE = new FTBUtilitiesLoadedChunkManager();
    public final Map<TicketKey, ForgeChunkManager.Ticket> ticketMap = new HashMap<TicketKey, ForgeChunkManager.Ticket>();
    private final Map<ChunkDimPos, ForgeChunkManager.Ticket> chunkTickets = new HashMap<ChunkDimPos, ForgeChunkManager.Ticket>();

    public void clear() {
        this.ticketMap.clear();
        this.chunkTickets.clear();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        int dim = world.field_73011_w.getDimension();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            TicketKey key = new TicketKey(dim, ticket.getModData().func_74779_i("Team"));
            if (key.teamId.isEmpty()) continue;
            this.ticketMap.put(key, ticket);
            for (ChunkPos pos : ticket.getChunkList()) {
                this.chunkTickets.put(new ChunkDimPos(pos, key.dimension), ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
            }
        }
    }

    @Nullable
    public ForgeChunkManager.Ticket requestTicket(MinecraftServer server, TicketKey key) {
        WorldServer worldServer;
        ForgeChunkManager.Ticket ticket = this.ticketMap.get(key);
        if (ticket == null && DimensionManager.isDimensionRegistered((int)key.dimension) && (ticket = ForgeChunkManager.requestTicket((Object)FTBUtilities.INST, (World)(worldServer = server.func_71218_a(key.dimension)), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.ticketMap.put(key, ticket);
            ticket.getModData().func_74778_a("Team", key.teamId);
        }
        return ticket;
    }

    public void forceChunk(MinecraftServer server, ClaimedChunk chunk) {
        block7: {
            if (chunk.forced != null && chunk.forced.booleanValue()) {
                return;
            }
            ChunkDimPos pos = chunk.getPos();
            ForgeChunkManager.Ticket ticket = this.requestTicket(server, new TicketKey(pos.dim, chunk.getTeam().getId()));
            try {
                Objects.requireNonNull(ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos.getChunkPos());
                chunk.forced = true;
                this.chunkTickets.put(pos, ticket);
                if (FTBUtilitiesConfig.debugging.log_chunkloading) {
                    FTBUtilities.LOGGER.info(chunk.getTeam().getTitle().func_150260_c() + " forced " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName((int)pos.dim).func_150260_c());
                }
            }
            catch (Exception ex) {
                if (!DimensionManager.isDimensionRegistered((int)chunk.getPos().dim)) {
                    FTBUtilities.LOGGER.error("Failed to force chunk " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName((int)pos.dim).func_150260_c() + " from " + chunk.getTeam().getTitle().func_150260_c() + ": Dimension " + chunk.getPos().dim + " not registered!");
                } else {
                    FTBUtilities.LOGGER.error("Failed to force chunk " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName((int)pos.dim).func_150260_c() + " from " + chunk.getTeam().getTitle().func_150260_c() + ": " + ex);
                    if (FTBLibConfig.debugging.print_more_errors) {
                        ex.printStackTrace();
                    }
                }
                if (!FTBUtilitiesConfig.world.unload_erroring_chunks) break block7;
                FTBUtilities.LOGGER.warn("Unloading erroring chunk at " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName((int)pos.dim).func_150260_c());
                chunk.setLoaded(false);
            }
        }
    }

    public void unforceChunk(ClaimedChunk chunk) {
        if (chunk.forced != null && !chunk.forced.booleanValue()) {
            return;
        }
        ChunkDimPos pos = chunk.getPos();
        ForgeChunkManager.Ticket ticket = this.chunkTickets.get(pos);
        if (ticket == null) {
            return;
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos.getChunkPos());
        this.chunkTickets.remove(pos);
        chunk.forced = false;
        if (ticket.getChunkList().isEmpty()) {
            this.ticketMap.remove(new TicketKey(pos.dim, chunk.getTeam().getId()));
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        if (FTBUtilitiesConfig.debugging.log_chunkloading) {
            FTBUtilities.LOGGER.info(chunk.getTeam().getTitle().func_150260_c() + " unforced " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName((int)pos.dim).func_150260_c());
        }
    }

    public boolean canForceChunks(ForgeTeam team) {
        List members = team.getMembers();
        for (ForgePlayer player : members) {
            if (!player.isOnline()) continue;
            return true;
        }
        for (ForgePlayer player : members) {
            if (!player.hasPermission("ftbutilities.chunkloader.load_offline")) continue;
            return true;
        }
        return false;
    }
}

