/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.util.VanillaPacketDispatcher;
import com.blakebr0.extendedcrafting.block.BlockEnderAlternator;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.lib.EmptyContainer;
import com.blakebr0.extendedcrafting.tile.AbstractExtendedTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEnderCrafter
extends AbstractExtendedTable
implements ITickable {
    private int progress;
    private int progressReq;
    private TableCrafting tableCrafting = new TableCrafting(new EmptyContainer(), this);

    public TileEnderCrafter() {
        super("ender_crafter");
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        IEnderCraftingRecipe recipe = EnderCrafterRecipeManager.getInstance().findMatchingRecipe(this.tableCrafting, this.func_145831_w());
        ItemStack result = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b(this.tableCrafting);
        ItemStack output = this.getResult();
        if (result.func_190926_b() || !output.func_190926_b() && !StackHelper.canCombineStacks((ItemStack)output, (ItemStack)result)) {
            if (this.progress > 0 || this.progressReq > 0) {
                this.progress = 0;
                this.progressReq = 0;
                this.func_70296_d();
            }
            return;
        }
        List<BlockPos> alternators = this.getAlternatorPositions();
        if (alternators.isEmpty() || recipe == null) {
            return;
        }
        this.progress(alternators.size(), recipe.getEnderCrafterTimeSeconds());
        for (BlockPos pos : alternators) {
            if (!this.func_145831_w().func_175623_d(pos.func_177984_a())) continue;
            ((WorldServer)this.func_145831_w()).func_180505_a(EnumParticleTypes.PORTAL, false, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.1, new int[0]);
        }
        if (this.progress >= this.progressReq) {
            for (int i = 0; i < this.matrix.size(); ++i) {
                this.func_70298_a(i, 1);
            }
            this.updateResult(result);
            this.progress = 0;
        }
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("ProgressReq", this.progressReq);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("Progress");
        this.progressReq = tag.func_74762_e("ProgressReq");
    }

    public void updateResult(ItemStack result) {
        if (this.result.func_190926_b()) {
            this.setResult(result);
        } else {
            this.result.func_190917_f(result.func_190916_E());
        }
    }

    public List<BlockPos> getAlternatorPositions() {
        ArrayList<BlockPos> alternators = new ArrayList<BlockPos>();
        Iterable blocks = BlockPos.func_177980_a((BlockPos)this.func_174877_v().func_177982_a(-3, -3, -3), (BlockPos)this.func_174877_v().func_177982_a(3, 3, 3));
        for (BlockPos aoePos : blocks) {
            Block block = this.func_145831_w().func_180495_p(aoePos).func_177230_c();
            if (!(block instanceof BlockEnderAlternator)) continue;
            alternators.add(aoePos);
        }
        return alternators;
    }

    public int getProgressRequired() {
        return this.progressReq;
    }

    public int getProgress() {
        return this.progress;
    }

    private void progress(int alternators, int timeRequired) {
        ++this.progress;
        int timeReq = 20 * timeRequired;
        this.progressReq = (int)Math.max((float)timeReq - (float)timeReq * (ModConfig.confEnderAlternatorEff * (float)alternators), 20.0f);
    }

    @Override
    protected void dirtyPacket() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }
}

