/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.endercrafter;

import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;

public class EnderCrafterRecipeManager {
    private static final EnderCrafterRecipeManager INSTANCE = new EnderCrafterRecipeManager();
    private final List<IRecipe> recipes = new ArrayList<IRecipe>();

    public static EnderCrafterRecipeManager getInstance() {
        return INSTANCE;
    }

    public void addShaped(ItemStack result, int time, CraftingHelper.ShapedPrimer primer) {
        this.addShaped(result, time, (NonNullList<Ingredient>)primer.input);
    }

    public void addShaped(ItemStack result, int time, NonNullList<Ingredient> recipe) {
        TableRecipeShaped craft = new TableRecipeShaped(1, result, 3, 3, recipe);
        if (ModConfig.confEnderEnabled) {
            craft.enderCrafterRecipeTimeRequired = time;
            this.recipes.add(craft);
        }
    }

    public IEnderCraftingRecipe findMatchingRecipe(TableCrafting grid, World world) {
        for (IRecipe iRecipe : this.recipes) {
            if (!iRecipe.func_77569_a((InventoryCrafting)grid, world)) continue;
            return (IEnderCraftingRecipe)iRecipe;
        }
        return null;
    }

    public List<IRecipe> getRecipes() {
        return this.recipes;
    }

    public void removeRecipes(ItemStack stack) {
        this.recipes.removeIf(o -> o != null && o.func_77571_b().func_77969_a(stack));
    }

    public List<IRecipe> getRecipes(int size) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : this.getRecipes()) {
            if (!recipe.func_194133_a(size, size)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }
}

