/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.EnderCrafting")
public class EnderCrafting {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        EnderCrafting.addShaped(output, ingredients, ModConfig.confEnderTimeRequired);
    }

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients, int seconds) {
        int height = ingredients.length;
        int width = 0;
        for (IIngredient[] row : ingredients) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList input = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
        int i = 0;
        Iterator it = Arrays.stream(ingredients).flatMap(Arrays::stream).map(CraftTweakerUtils::toIngredient).iterator();
        while (it.hasNext()) {
            input.set(i++, (Object)((Ingredient)it.next()));
        }
        TableRecipeShaped recipe = new TableRecipeShaped(1, CraftTweakerMC.getItemStack((IItemStack)output), width, height, (NonNullList<Ingredient>)input);
        recipe.enderCrafterRecipeTimeRequired = seconds;
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        EnderCrafting.addShapeless(output, ingredients, ModConfig.confEnderTimeRequired);
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients, int seconds) {
        TableRecipeShapeless recipe = new TableRecipeShapeless(1, CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerUtils.toIngredients(ingredients));
        recipe.enderCrafterRecipeTimeRequired = seconds;
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerMC.getItemStack((IItemStack)target)));
    }

    private static class Remove
    implements IAction {
        final ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            EnderCrafterRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Ender Crafting recipes for " + this.remove.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        final IRecipe recipe;

        public Add(IRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            EnderCrafterRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding an Ender Crafting recipe for " + this.recipe.func_77571_b().func_82833_r();
        }
    }
}

