/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.container;

import com.blakebr0.extendedcrafting.crafting.table.TableCraftResult;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableResultHandler;
import com.blakebr0.extendedcrafting.tile.AbstractExtendedTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class AbstractTableContainer
extends Container {
    public static final int SLOT_SIZE = 18;
    public static final int PLAYER_INV_WIDTH = 9;
    public static final int PLAYER_INV_ROWS = 3;
    public static final int GRID_START_Y = 18;
    public final InventoryCrafting matrix;
    public final IInventory result;
    public final AbstractExtendedTable tile;

    public AbstractTableContainer(InventoryPlayer player, AbstractExtendedTable tile, int guiWidth, int guiHeight, int gridStartX, int outputSlotX) {
        int x;
        int y;
        this.matrix = new TableCrafting(this, tile);
        this.result = new TableCraftResult(tile);
        this.tile = tile;
        int lineSize = tile.getLineSize();
        int outputSlotY = 18 + (lineSize - 1) * 18 / 2;
        this.func_75146_a(new TableResultHandler(this.matrix, this.result, tile.func_145831_w(), 0, outputSlotX, outputSlotY));
        for (y = 0; y < lineSize; ++y) {
            for (x = 0; x < lineSize; ++x) {
                this.func_75146_a(new Slot((IInventory)this.matrix, x + y * lineSize, gridStartX + x * 18, 18 + y * 18));
            }
        }
        int hotbarStartY = guiHeight - 18 - 6;
        int playerInvStartX = AbstractTableContainer.getPlayerInvStartX(guiWidth);
        int playerInvStartY = hotbarStartY - 54 - 4;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player, x + (y + 1) * 9, playerInvStartX + x * 18, playerInvStartY + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player, x, playerInvStartX + x * 18, hotbarStartY));
        }
    }

    public static int getPlayerInvStartX(int guiWidth) {
        return (guiWidth - 162) / 2 + 1;
    }

    public void func_75130_a(IInventory matrix) {
        this.result.func_70299_a(0, TableRecipeManager.getInstance().findMatchingRecipe(this.matrix, this.tile.func_145831_w()));
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        int size = this.tile.func_70302_i_();
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int gridEnd = size + 1;
            int maxSlots = this.field_75151_b.size();
            if (slotNumber == 0) {
                if (!this.func_75135_a(itemstack1, gridEnd, maxSlots, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (slotNumber >= gridEnd && slotNumber < maxSlots ? !this.func_75135_a(itemstack1, 1, gridEnd, false) : !this.func_75135_a(itemstack1, gridEnd, maxSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
            this.func_75130_a((IInventory)this.matrix);
        }
        return itemstack;
    }
}

