/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.tiles;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.inventory.ContainerSimulationChamber;
import mustapelto.deepmoblearning.common.inventory.ContainerTileEntity;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerDataModel;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerInputWrapper;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerOutput;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerPolymerClay;
import mustapelto.deepmoblearning.common.tiles.CraftingState;
import mustapelto.deepmoblearning.common.tiles.TileEntityMachine;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntitySimulationChamber
extends TileEntityMachine {
    private final ItemHandlerDataModel inputDataModel = new ItemHandlerDataModel(){

        protected void onContentsChanged(int slot) {
            TileEntitySimulationChamber.this.onDataModelChanged();
        }
    };
    private final ItemHandlerInputWrapper dataModelWrapper = new ItemHandlerInputWrapper(this.inputDataModel);
    private final ItemHandlerPolymerClay inputPolymer = new ItemHandlerPolymerClay();
    private final ItemHandlerInputWrapper polymerWrapper = new ItemHandlerInputWrapper(this.inputPolymer);
    private final ItemHandlerOutput outputLiving = new ItemHandlerOutput();
    private final ItemHandlerOutput outputPristine = new ItemHandlerOutput();
    private boolean pristineSuccess = false;
    private static final String NBT_INPUT_DATA_MODEL = "inputDataModel";
    private static final String NBT_INPUT_POLYMER = "inputPolymer";
    private static final String NBT_OUTPUT_LIVING = "outputLiving";
    private static final String NBT_OUTPUT_PRISTINE = "outputPristine";
    private static final String NBT_PRISTINE_SUCCESS = "pristineSuccess";
    private static final String NBT_LEGACY_INPUT_DATA_MODEL = "dataModel";
    private static final String NBT_LEGACY_INPUT_POLYMER = "polymer";
    private static final String NBT_LEGACY_OUTPUT_LIVING = "lOutput";
    private static final String NBT_LEGACY_OUTPUT_PRISTINE = "pOutput";
    private static final String NBT_LEGACY_PRISTINE_SUCCESS = "craftSuccess";

    public TileEntitySimulationChamber() {
        super(2000000, 25600);
    }

    @Override
    protected void startCrafting() {
        super.startCrafting();
        int pristineChance = DataModelHelper.getPristineChance(this.getDataModel());
        int random = ThreadLocalRandom.current().nextInt(100);
        this.pristineSuccess = random < pristineChance;
        this.inputPolymer.voidItem();
    }

    @Override
    protected boolean canStartCrafting() {
        return super.canStartCrafting() && this.hasPolymerClay() && this.canContinueCrafting();
    }

    @Override
    protected boolean canContinueCrafting() {
        return super.canContinueCrafting() && this.hasDataModel() && this.canDataModelSimulate() && !this.isLivingMatterOutputFull() && !this.isPristineMatterOutputFull();
    }

    @Override
    protected void finishCrafting() {
        ItemStack dataModel = this.getDataModel();
        DataModelHelper.getDataModelMetadata(dataModel).ifPresent(metadata -> {
            DataModelHelper.addSimulation(dataModel);
            ItemStack oldLivingMatterOutput = this.outputLiving.getStackInSlot(0);
            ItemStack newLivingMatterOutput = metadata.getLivingMatter(oldLivingMatterOutput.func_190916_E() + 1);
            this.outputLiving.setStackInSlot(0, newLivingMatterOutput);
            if (this.pristineSuccess) {
                ItemStack oldPristineMatterOutput = this.outputPristine.getStackInSlot(0);
                ItemStack newPristineMatterOutput = metadata.getPristineMatter(oldPristineMatterOutput.func_190916_E() + 1);
                this.outputPristine.setStackInSlot(0, newPristineMatterOutput);
            }
        });
        this.resetCrafting();
    }

    @Override
    protected void resetCrafting() {
        super.resetCrafting();
        this.pristineSuccess = false;
    }

    @Override
    protected int getCraftingDuration() {
        return DMLConfig.MACHINE_SETTINGS.SIMULATION_CHAMBER_PROCESSING_TIME;
    }

    public boolean isPristineSuccess() {
        return this.pristineSuccess;
    }

    @Override
    public int getCraftingEnergyCost() {
        return DataModelHelper.getSimulationEnergy(this.getDataModel());
    }

    @Override
    protected CraftingState updateCraftingState() {
        if (!this.hasDataModel()) {
            return CraftingState.IDLE;
        }
        if (!this.canContinueCrafting() || !this.isCrafting() && !this.canStartCrafting()) {
            return CraftingState.ERROR;
        }
        return CraftingState.RUNNING;
    }

    @Override
    public ContainerTileEntity getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerSimulationChamber(this, inventoryPlayer);
    }

    private void onDataModelChanged() {
        if (!this.field_145850_b.field_72995_K) {
            this.resetCrafting();
        }
    }

    public ItemStack getDataModel() {
        return this.inputDataModel.getStackInSlot(0);
    }

    public boolean hasDataModel() {
        return ItemStackHelper.isDataModel(this.getDataModel());
    }

    public boolean canDataModelSimulate() {
        return DataModelHelper.canSimulate(this.getDataModel());
    }

    public ItemStack getPolymerClay() {
        return this.inputPolymer.getStackInSlot(0);
    }

    public boolean hasPolymerClay() {
        return ItemStackHelper.isPolymerClay(this.getPolymerClay());
    }

    public boolean isLivingMatterOutputFull() {
        ItemStack livingMatterStack = this.outputLiving.getStackInSlot(0);
        if (livingMatterStack.func_190926_b()) {
            return false;
        }
        boolean stackIsFull = livingMatterStack.func_190916_E() >= this.outputLiving.getSlotLimit(0);
        boolean stackMatchesDataModel = DataModelHelper.getDataModelMatchesLivingMatter(this.getDataModel(), livingMatterStack);
        return stackIsFull || !stackMatchesDataModel;
    }

    public boolean isPristineMatterOutputFull() {
        ItemStack pristineMatterStack = this.outputPristine.getStackInSlot(0);
        if (pristineMatterStack.func_190926_b()) {
            return false;
        }
        boolean stackIsFull = pristineMatterStack.func_190916_E() >= this.outputPristine.getSlotLimit(0);
        boolean stackMatchesDataModel = DataModelHelper.getDataModelMatchesPristineMatter(this.getDataModel(), pristineMatterStack);
        return stackIsFull || !stackMatchesDataModel;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDataModel, this.inputPolymer, this.outputLiving, this.outputPristine}));
            }
            if (!DMLConfig.MACHINE_SETTINGS.LEGACY_MACHINE_SIDEDNESS) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.dataModelWrapper, this.polymerWrapper, this.outputLiving, this.outputPristine}));
            }
            if (facing == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDataModel, this.inputPolymer}));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.outputPristine, this.outputLiving}));
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ByteBuf getUpdateData() {
        ByteBuf buf = super.getUpdateData();
        buf.writeBoolean(this.pristineSuccess);
        return buf;
    }

    @Override
    public void handleUpdateData(ByteBuf buf) {
        super.handleUpdateData(buf);
        this.pristineSuccess = buf.readBoolean();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a(NBT_INPUT_DATA_MODEL, (NBTBase)this.inputDataModel.serializeNBT());
        inventory.func_74782_a(NBT_INPUT_POLYMER, (NBTBase)this.inputPolymer.serializeNBT());
        inventory.func_74782_a(NBT_OUTPUT_LIVING, (NBTBase)this.outputLiving.serializeNBT());
        inventory.func_74782_a(NBT_OUTPUT_PRISTINE, (NBTBase)this.outputPristine.serializeNBT());
        compound.func_74782_a("inventory", (NBTBase)inventory);
        compound.func_74775_l("crafting").func_74757_a(NBT_PRISTINE_SUCCESS, this.pristineSuccess);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (TileEntitySimulationChamber.isLegacyNBT(compound)) {
            this.inputDataModel.deserializeNBT(compound.func_74775_l(NBT_LEGACY_INPUT_DATA_MODEL));
            this.inputPolymer.deserializeNBT(compound.func_74775_l(NBT_LEGACY_INPUT_POLYMER));
            this.outputLiving.deserializeNBT(compound.func_74775_l(NBT_LEGACY_OUTPUT_LIVING));
            this.outputPristine.deserializeNBT(compound.func_74775_l(NBT_LEGACY_OUTPUT_PRISTINE));
            this.pristineSuccess = NBTHelper.getBoolean(compound, NBT_LEGACY_PRISTINE_SUCCESS, false);
        } else {
            NBTTagCompound inventory = compound.func_74775_l("inventory");
            this.inputDataModel.deserializeNBT(inventory.func_74775_l(NBT_INPUT_DATA_MODEL));
            this.inputPolymer.deserializeNBT(inventory.func_74775_l(NBT_INPUT_POLYMER));
            this.outputLiving.deserializeNBT(inventory.func_74775_l(NBT_OUTPUT_LIVING));
            this.outputPristine.deserializeNBT(inventory.func_74775_l(NBT_OUTPUT_PRISTINE));
            this.pristineSuccess = NBTHelper.getBoolean(compound.func_74775_l("crafting"), NBT_PRISTINE_SUCCESS, false);
        }
    }

    private static boolean isLegacyNBT(NBTTagCompound nbt) {
        return nbt.func_74764_b(NBT_LEGACY_INPUT_DATA_MODEL) || nbt.func_74764_b(NBT_LEGACY_INPUT_POLYMER) || nbt.func_74764_b(NBT_LEGACY_OUTPUT_LIVING) || nbt.func_74764_b(NBT_LEGACY_OUTPUT_PRISTINE) || nbt.func_74764_b(NBT_LEGACY_PRISTINE_SUCCESS);
    }
}

