/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import mustapelto.deepmoblearning.client.gui.GuiSimulationChamber;
import mustapelto.deepmoblearning.common.util.MathHelper;

public class StringAnimator {
    private final LinkedHashMap<GuiSimulationChamber.AnimatedString, AnimatedString> strings = new LinkedHashMap();
    private final List<GuiSimulationChamber.AnimatedString> keys = new ArrayList<GuiSimulationChamber.AnimatedString>();
    private int currentStringIndex = 0;
    private float totalDuration = 0.0f;
    private boolean finished = false;

    public void reset() {
        this.currentStringIndex = 0;
        this.finished = false;
        this.strings.values().forEach(AnimatedString::reset);
    }

    public void addString(GuiSimulationChamber.AnimatedString key, String string) {
        this.addString(key, string, 1.0f, false);
    }

    public void addString(GuiSimulationChamber.AnimatedString key, String string, float speed, boolean loop) {
        AnimatedString newString = new AnimatedString(string, speed, loop);
        this.strings.put(key, newString);
        this.keys.add(key);
        this.totalDuration += newString.getDuration();
    }

    public void setString(GuiSimulationChamber.AnimatedString key, String string) {
        AnimatedString oldString = this.strings.get((Object)key);
        AnimatedString newString = new AnimatedString(string, oldString.getSpeed(), oldString.isLoop());
        this.strings.replace(key, newString);
        this.totalDuration -= oldString.getDuration();
        this.totalDuration += newString.getDuration();
    }

    public void advance(float amount) {
        if (this.finished) {
            return;
        }
        AnimatedString currentString = this.getByIndex(this.currentStringIndex);
        if (this.currentStringIndex == this.strings.size() && currentString.isFinished()) {
            return;
        }
        while (amount > 0.0f) {
            amount = currentString.advance(amount);
            if (!currentString.isFinished()) continue;
            if (this.currentStringIndex < this.strings.size() - 1) {
                ++this.currentStringIndex;
                currentString = this.getByIndex(this.currentStringIndex);
                continue;
            }
            this.finished = true;
            break;
        }
    }

    public List<String> getCurrentStrings() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i <= this.currentStringIndex; ++i) {
            result.add(this.strings.get((Object)this.keys.get(i)).getString());
        }
        return result;
    }

    public void goToPosition(float position) {
        this.reset();
        this.advance(position);
    }

    public void goToRelativePosition(float relativePosition) {
        relativePosition = MathHelper.clamp(relativePosition, 0.0f, 1.0f);
        this.goToPosition(relativePosition * this.totalDuration);
    }

    private AnimatedString getByIndex(int index) {
        return this.strings.get((Object)this.keys.get(index));
    }

    public static class AnimatedString {
        private final String string;
        private final float speed;
        private final float duration;
        private final float formattedLength;
        private final boolean loop;
        private float position;
        private boolean finished;

        public AnimatedString(String string, float speed, boolean loop) {
            this.string = string;
            this.speed = speed;
            int tempActualLength = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\u00a7') {
                    ++tempActualLength;
                    continue;
                }
                ++i;
            }
            this.formattedLength = tempActualLength;
            this.duration = this.formattedLength * speed;
            this.loop = loop;
            this.position = 0.0f;
        }

        public float advance(float amount) {
            return this.goToPosition(this.position + amount);
        }

        private void finishIfDone() {
            if (this.position >= this.duration) {
                if (this.loop) {
                    this.reset();
                } else {
                    this.finished = true;
                }
            }
        }

        public float goToPosition(float position) {
            this.position = Math.min(position, this.duration);
            this.finishIfDone();
            return position - this.duration;
        }

        public String getString() {
            float floatIndex = this.position / this.duration * this.formattedLength;
            int endIndex = 0;
            int lettersAdded = 0;
            for (int i = 0; i < this.string.length() && (float)lettersAdded <= floatIndex; ++i) {
                if (this.string.charAt(i) == '\u00a7') {
                    if (i < this.string.length() - 1) {
                        endIndex += 2;
                    }
                    ++i;
                    continue;
                }
                ++lettersAdded;
                ++endIndex;
            }
            return this.string.substring(0, endIndex);
        }

        public float getSpeed() {
            return this.speed;
        }

        public float getDuration() {
            return this.duration;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isLoop() {
            return this.loop;
        }

        public void reset() {
            this.position = 0.0f;
            this.finished = false;
        }
    }
}

