/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui.text;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.controls.gui.text.IWordMatcher;
import java.util.ArrayList;
import java.util.stream.Stream;

@FunctionalInterface
public interface IWordWrapAlgorithm {
    public static final IWordWrapAlgorithm DEFAULT_WORDWRAP_ALGORITHM = (text, width, matcher) -> {
        String p;
        if (width <= 0 || text == null || text.isEmpty()) {
            return Stream.of(text);
        }
        ArrayList<String> res = new ArrayList<String>();
        String lot = text;
        do {
            if (matcher != null) {
                p = matcher.trimToWidth(text, width);
            } else {
                p = GuiRenderHelper.instance.font.func_78269_a(lot, width);
                if (p == null || p.length() == 0) {
                    return Stream.of(lot);
                }
            }
            res.add(p);
        } while (!(lot = lot.substring(p.length())).isEmpty());
        return res.stream();
    };
    public static final IWordWrapAlgorithm DEFAULT_NEWLINE_WORDWRAP_ALGORITHM = (text, width, matcher) -> {
        String[] lines = text.toString().split("\\R");
        if (width <= 0) {
            return Stream.of(lines);
        }
        return Stream.of(lines).flatMap(L -> DEFAULT_WORDWRAP_ALGORITHM.wrap((String)L, width, matcher));
    };

    public Stream<String> wrap(String var1, int var2, IWordMatcher var3);

    default public Stream<String> wrap(String text, int width) {
        return this.wrap(text, width, IWordMatcher.DEFAULT_MATCHER);
    }

    default public Stream<String> wrap(String text) {
        return this.wrap(text, -1, IWordMatcher.DEFAULT_MATCHER);
    }
}

