/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.render.helpers;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ModularBoxRenderer {
    public static final int CONNECT_YNEG = 1;
    public static final int CONNECT_YPOS = 2;
    public static final int CONNECT_ZNEG = 4;
    public static final int CONNECT_ZPOS = 8;
    public static final int CONNECT_XNEG = 16;
    public static final int CONNECT_XPOS = 32;
    public static final int CONNECT_YNEG_ZNEG = 64;
    public static final int CONNECT_YNEG_ZPOS = 128;
    public static final int CONNECT_YNEG_XNEG = 256;
    public static final int CONNECT_YNEG_XPOS = 512;
    public static final int CONNECT_YPOS_ZNEG = 1024;
    public static final int CONNECT_YPOS_ZPOS = 2048;
    public static final int CONNECT_YPOS_XNEG = 4096;
    public static final int CONNECT_YPOS_XPOS = 8192;
    public static final int CONNECT_ZNEG_XNEG = 16384;
    public static final int CONNECT_ZNEG_XPOS = 32768;
    public static final int CONNECT_ZPOS_XNEG = 65536;
    public static final int CONNECT_ZPOS_XPOS = 131072;
    public static final int CUT_YNEG = 1;
    public static final int CUT_YPOS = 2;
    public static final int CUT_ZNEG = 4;
    public static final int CUT_ZPOS = 8;
    public static final int CUT_XNEG = 16;
    public static final int CUT_XPOS = 32;
    public static final int CUT_ALL = 63;
    private static final int TEST_YNEG_ZNEG = 5;
    private static final int TEST_YNEG_ZPOS = 9;
    private static final int TEST_YNEG_XNEG = 17;
    private static final int TEST_YNEG_XPOS = 33;
    private static final int TEST_YPOS_ZNEG = 6;
    private static final int TEST_YPOS_ZPOS = 10;
    private static final int TEST_YPOS_XNEG = 18;
    private static final int TEST_YPOS_XPOS = 34;
    private static final int TEST_ZNEG_XNEG = 20;
    private static final int TEST_ZNEG_XPOS = 36;
    private static final int TEST_ZPOS_XNEG = 24;
    private static final int TEST_ZPOS_XPOS = 40;
    private static final int TEST_YNEG_ZNEG_XNEG = 21;
    private static final int TEST_YNEG_ZNEG_XPOS = 37;
    private static final int TEST_YNEG_ZPOS_XNEG = 25;
    private static final int TEST_YNEG_ZPOS_XPOS = 41;
    private static final int TEST_YPOS_ZNEG_XNEG = 22;
    private static final int TEST_YPOS_ZNEG_XPOS = 38;
    private static final int TEST_YPOS_ZPOS_XNEG = 26;
    private static final int TEST_YPOS_ZPOS_XPOS = 42;
    private static final int PLANE_YNEG = 961;
    private static final int PLANE_YPOS = 15362;
    public static final float[] COLOR_WHITE = new float[]{1.0f, 1.0f, 1.0f};
    public static final int[] sideCut = new int[]{1, 2, 4, 8, 16, 32};
    private ChamRender renderHelper;
    private double unit = 0.0625;
    private float[][] exteriorColor = new float[6][3];
    private float[][] interiorColor = new float[6][3];
    private float[][] cutColor = new float[6][3];
    private TextureAtlasSprite[] exteriorIcon = new TextureAtlasSprite[6];
    private TextureAtlasSprite[] interiorIcon = new TextureAtlasSprite[6];
    private TextureAtlasSprite[] cutIcon = new TextureAtlasSprite[6];
    public boolean flipOpposite;

    public ModularBoxRenderer(ChamRender renderer) {
        this.renderHelper = renderer;
    }

    private void copyFrom(float[] target, float[] source) {
        target[0] = source[0];
        target[1] = source[1];
        target[2] = source[2];
    }

    private void copyFrom(float[] target, float r, float g, float b) {
        target[0] = r;
        target[1] = g;
        target[2] = b;
    }

    public void setColor(float[] color) {
        this.setExteriorColor(color);
        this.setInteriorColor(color);
        this.setCutColor(color);
    }

    public void setScaledColor(float[] color, float scale) {
        this.setScaledExteriorColor(color, scale);
        this.setScaledInteriorColor(color, scale);
        this.setScaledCutColor(color, scale);
    }

    public void setExteriorColor(float[] color) {
        for (int i = 0; i < 6; ++i) {
            this.copyFrom(this.exteriorColor[i], color);
        }
    }

    public void setExteriorColor(float[] color, int side) {
        this.copyFrom(this.exteriorColor[side], color);
    }

    public void setScaledExteriorColor(float[] color, float scale) {
        for (int i = 0; i < 6; ++i) {
            this.copyFrom(this.exteriorColor[i], color[0] * scale, color[1] * scale, color[2] * scale);
        }
    }

    public void setScaledExteriorColor(float[] color, float scale, int side) {
        this.copyFrom(this.exteriorColor[side], color[0] * scale, color[1] * scale, color[2] * scale);
    }

    public void setInteriorColor(float[] color) {
        for (int i = 0; i < 6; ++i) {
            this.copyFrom(this.interiorColor[i], color);
        }
    }

    public void setInteriorColor(float[] color, int side) {
        side = side % 2 == 0 ? side + 1 : side - 1;
        this.copyFrom(this.interiorColor[side], color);
    }

    public void setScaledInteriorColor(float[] color, float scale) {
        for (int i = 0; i < 6; ++i) {
            this.copyFrom(this.interiorColor[i], color[0] * scale, color[1] * scale, color[2] * scale);
        }
    }

    public void setCutColor(float[] color) {
        for (int i = 0; i < 6; ++i) {
            this.copyFrom(this.cutColor[i], color);
        }
    }

    public void setCutColor(float[] color, int side) {
        this.copyFrom(this.cutColor[side], color);
    }

    public void setScaledCutColor(float[] color, float scale) {
        for (int i = 0; i < 6; ++i) {
            this.copyFrom(this.cutColor[i], color[0] * scale, color[1] * scale, color[2] * scale);
        }
    }

    public void setIcon(TextureAtlasSprite icon) {
        this.setExteriorIcon(icon);
        this.setInteriorIcon(icon);
        this.setCutIcon(icon);
    }

    public void setIcon(TextureAtlasSprite icon, int side) {
        this.setExteriorIcon(icon, side);
        this.setInteriorIcon(icon, side);
        this.setCutIcon(icon, side);
    }

    public void setExteriorIcon(TextureAtlasSprite icon) {
        for (int i = 0; i < 6; ++i) {
            this.exteriorIcon[i] = icon;
        }
    }

    public void setExteriorIcon(TextureAtlasSprite icon, int side) {
        this.exteriorIcon[side] = icon;
    }

    public void setInteriorIcon(TextureAtlasSprite icon) {
        for (int i = 0; i < 6; ++i) {
            this.interiorIcon[i] = icon;
        }
    }

    public void setInteriorIcon(TextureAtlasSprite icon, int side) {
        side = side % 2 == 0 ? side + 1 : side - 1;
        this.interiorIcon[side] = icon;
    }

    public void setCutIcon(TextureAtlasSprite icon) {
        for (int i = 0; i < 6; ++i) {
            this.cutIcon[i] = icon;
        }
    }

    public void setCutIcon(TextureAtlasSprite icon, int side) {
        this.cutIcon[side] = icon;
    }

    public void setUnit(double unit) {
        this.unit = unit;
    }

    public void renderOctant(IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xOff, double yOff, double zOff, int connectedFlags, int cutFlags) {
        double xPos = xOff + 0.5;
        double yPos = yOff + 0.5;
        double zPos = zOff + 0.5;
        this.renderExterior(blockAccess, state, pos, xOff, yOff, zOff, xPos, yPos, zPos, connectedFlags, cutFlags);
        this.renderInterior(blockAccess, state, pos, xOff, yOff, zOff, xPos, yPos, zPos, connectedFlags, cutFlags);
    }

    public void renderBox(IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos, int connectedFlags, int cutFlags) {
        this.renderExterior(blockAccess, state, pos, xNeg, yNeg, zNeg, xPos, yPos, zPos, connectedFlags, cutFlags);
        this.renderInterior(blockAccess, state, pos, xNeg, yNeg, zNeg, xPos, yPos, zPos, connectedFlags, cutFlags);
    }

    public void renderSolidBox(IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
        this.renderExterior(blockAccess, state, pos, xNeg, yNeg, zNeg, xPos, yPos, zPos, 0, 0);
    }

    public void renderExterior(IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos, int connectedFlags, int cutFlags) {
        if ((cutFlags & 1) != 0) {
            connectedFlags |= 1;
        }
        if ((cutFlags & 2) != 0) {
            connectedFlags |= 2;
        }
        if ((cutFlags & 4) != 0) {
            connectedFlags |= 4;
        }
        if ((cutFlags & 8) != 0) {
            connectedFlags |= 8;
        }
        if ((cutFlags & 0x10) != 0) {
            connectedFlags |= 0x10;
        }
        if ((cutFlags & 0x20) != 0) {
            connectedFlags |= 0x20;
        }
        this.renderHelper.setRenderBounds(xNeg, yNeg, zNeg, xPos, yPos, zPos);
        if ((connectedFlags & 1) == 0) {
            this.renderExteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
        }
        if ((connectedFlags & 2) == 0) {
            this.renderExteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
        }
        if ((connectedFlags & 4) == 0) {
            this.renderExteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
        }
        if ((connectedFlags & 8) == 0) {
            this.renderExteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
        }
        if ((connectedFlags & 0x10) == 0) {
            this.renderExteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
        }
        if ((connectedFlags & 0x20) == 0) {
            this.renderExteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
        }
        if (this.unit == 0.0) {
            return;
        }
        if ((cutFlags & 5) != 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg, zNeg, xPos - this.unit, yNeg + this.unit, zNeg + this.unit);
            if ((cutFlags & 1) != 0 && (connectedFlags & 4) == 0) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 4) != 0 && (connectedFlags & 1) == 0) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 9) != 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg, zPos - this.unit, xPos - this.unit, yNeg + this.unit, zPos);
            if ((cutFlags & 1) != 0 && (connectedFlags & 8) == 0) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 8) != 0 && (connectedFlags & 1) == 0) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x11) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yNeg, zNeg + this.unit, xNeg + this.unit, yNeg + this.unit, zPos - this.unit);
            if ((cutFlags & 1) != 0 && (connectedFlags & 0x10) == 0) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags & 1) == 0) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x21) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg, zNeg + this.unit, xPos, yNeg + this.unit, zPos - this.unit);
            if ((cutFlags & 1) != 0 && (connectedFlags & 0x20) == 0) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags & 1) == 0) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 6) != 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yPos - this.unit, zNeg, xPos - this.unit, yPos, zNeg + this.unit);
            if ((cutFlags & 2) != 0 && (connectedFlags & 4) == 0) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 4) != 0 && (connectedFlags & 2) == 0) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0xA) != 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yPos - this.unit, zPos - this.unit, xPos - this.unit, yPos, zPos);
            if ((cutFlags & 2) != 0 && (connectedFlags & 8) == 0) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 8) != 0 && (connectedFlags & 2) == 0) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x12) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yPos - this.unit, zNeg + this.unit, xNeg + this.unit, yPos, zPos - this.unit);
            if ((cutFlags & 2) != 0 && (connectedFlags & 0x10) == 0) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags & 2) == 0) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x22) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yPos - this.unit, zNeg + this.unit, xPos, yPos, zPos - this.unit);
            if ((cutFlags & 2) != 0 && (connectedFlags & 0x20) == 0) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags & 2) == 0) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x14) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yNeg + this.unit, zNeg, xNeg + this.unit, yPos - this.unit, zNeg + this.unit);
            if ((cutFlags & 4) != 0 && (connectedFlags & 0x10) == 0) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags & 4) == 0) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x24) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg + this.unit, zNeg, xPos, yPos - this.unit, zNeg + this.unit);
            if ((cutFlags & 4) != 0 && (connectedFlags & 0x20) == 0) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags & 4) == 0) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x18) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yNeg + this.unit, zPos - this.unit, xNeg + this.unit, yPos - this.unit, zPos);
            if ((cutFlags & 8) != 0 && (connectedFlags & 0x10) == 0) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags & 8) == 0) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x28) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg + this.unit, zPos - this.unit, xPos, yPos - this.unit, zPos);
            if ((cutFlags & 8) != 0 && (connectedFlags & 0x20) == 0) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags & 8) == 0) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x15) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yNeg, zNeg, xNeg + this.unit, yNeg + this.unit, zNeg + this.unit);
            if ((cutFlags & 1) != 0 && (connectedFlags | 4 | 0x10 | 0x4000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 4) != 0 && (connectedFlags | 1 | 0x10 | 0x100) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags | 1 | 4 | 0x40) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x25) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg, zNeg, xPos, yNeg + this.unit, zNeg + this.unit);
            if ((cutFlags & 1) != 0 && (connectedFlags | 4 | 0x20 | 0x8000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 4) != 0 && (connectedFlags | 1 | 0x20 | 0x200) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags | 1 | 4 | 0x40) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x19) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yNeg, zPos - this.unit, xNeg + this.unit, yNeg + this.unit, zPos);
            if ((cutFlags & 1) != 0 && (connectedFlags | 8 | 0x10 | 0x10000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 8) != 0 && (connectedFlags | 1 | 0x10 | 0x100) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags | 1 | 8 | 0x80) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x29) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg, zPos - this.unit, xPos, yNeg + this.unit, zPos);
            if ((cutFlags & 1) != 0 && (connectedFlags | 8 | 0x20 | 0x20000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 8) != 0 && (connectedFlags | 1 | 0x20 | 0x200) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags | 1 | 8 | 0x80) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x16) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yPos - this.unit, zNeg, xNeg + this.unit, yPos, zNeg + this.unit);
            if ((cutFlags & 2) != 0 && (connectedFlags | 4 | 0x10 | 0x4000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 4) != 0 && (connectedFlags | 2 | 0x10 | 0x1000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags | 2 | 4 | 0x400) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x26) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yPos - this.unit, zNeg, xPos, yPos, zNeg + this.unit);
            if ((cutFlags & 2) != 0 && (connectedFlags | 4 | 0x20 | 0x8000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 4) != 0 && (connectedFlags | 2 | 0x20 | 0x2000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags | 2 | 4 | 0x400) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x1A) != 0) {
            this.renderHelper.setRenderBounds(xNeg, yPos - this.unit, zPos - this.unit, xNeg + this.unit, yPos, zPos);
            if ((cutFlags & 2) != 0 && (connectedFlags | 8 | 0x10 | 0x10000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 8) != 0 && (connectedFlags | 2 | 0x10 | 0x1000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x10) != 0 && (connectedFlags | 2 | 8 | 0x800) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
        }
        if ((cutFlags & 0x2A) != 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yPos - this.unit, zPos - this.unit, xPos, yPos, zPos);
            if ((cutFlags & 2) != 0 && (connectedFlags | 8 | 0x20 | 0x20000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 8) != 0 && (connectedFlags | 2 | 0x20 | 0x2000) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((cutFlags & 0x20) != 0 && (connectedFlags | 2 | 8 | 0x800) != connectedFlags) {
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
        }
    }

    public void renderInterior(IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos, int connectedFlags, int cutFlags) {
        if ((cutFlags & 1) != 0) {
            connectedFlags |= 0x3C1;
        }
        if ((cutFlags & 2) != 0) {
            connectedFlags |= 0x3C02;
        }
        if ((cutFlags & 4) != 0) {
            connectedFlags |= 4;
        }
        if ((cutFlags & 8) != 0) {
            connectedFlags |= 8;
        }
        if ((cutFlags & 0x10) != 0) {
            connectedFlags |= 0x10;
        }
        if ((cutFlags & 0x20) != 0) {
            connectedFlags |= 0x20;
        }
        this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg + this.unit, zNeg + this.unit, xPos - this.unit, yPos - this.unit, zPos - this.unit);
        if ((connectedFlags & 1) == 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg, zNeg + this.unit, xPos - this.unit, yNeg + this.unit, zPos - this.unit);
            this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
        }
        if ((connectedFlags & 2) == 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yPos - this.unit, zNeg + this.unit, xPos - this.unit, yPos, zPos - this.unit);
            this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
        }
        if ((connectedFlags & 4) == 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg + this.unit, zNeg, xPos - this.unit, yPos - this.unit, zNeg + this.unit);
            this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
        }
        if ((connectedFlags & 8) == 0) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg + this.unit, zPos - this.unit, xPos - this.unit, yPos - this.unit, zPos);
            this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
        }
        if ((connectedFlags & 0x10) == 0) {
            this.renderHelper.setRenderBounds(xNeg, yNeg + this.unit, zNeg + this.unit, xNeg + this.unit, yPos - this.unit, zPos - this.unit);
            this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
        }
        if ((connectedFlags & 0x20) == 0) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg + this.unit, zNeg + this.unit, xPos, yPos - this.unit, zPos - this.unit);
            this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
        }
        if (this.unit == 0.0) {
            return;
        }
        if ((connectedFlags & 5) != 0 && (connectedFlags | 1 | 4 | 0x40) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg, zNeg, xPos - this.unit, yNeg + this.unit, zNeg + this.unit);
            if ((connectedFlags & 1) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((connectedFlags & 4) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 9) != 0 && (connectedFlags | 1 | 8 | 0x80) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yNeg, zPos - this.unit, xPos - this.unit, yNeg + this.unit, zPos);
            if ((connectedFlags & 1) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((connectedFlags & 8) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x11) != 0 && (connectedFlags | 1 | 0x10 | 0x100) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yNeg, zNeg + this.unit, xNeg + this.unit, yNeg + this.unit, zPos - this.unit);
            if ((connectedFlags & 1) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x10) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x21) != 0 && (connectedFlags | 1 | 0x20 | 0x200) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg, zNeg + this.unit, xPos, yNeg + this.unit, zPos - this.unit);
            if ((connectedFlags & 1) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x20) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 6) != 0 && (connectedFlags | 2 | 4 | 0x400) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yPos - this.unit, zNeg, xPos - this.unit, yPos, zNeg + this.unit);
            if ((connectedFlags & 2) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((connectedFlags & 4) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0xA) != 0 && (connectedFlags | 2 | 8 | 0x800) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg + this.unit, yPos - this.unit, zPos - this.unit, xPos - this.unit, yPos, zPos);
            if ((connectedFlags & 2) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((connectedFlags & 8) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x12) != 0 && (connectedFlags | 2 | 0x10 | 0x1000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yPos - this.unit, zNeg + this.unit, xNeg + this.unit, yPos, zPos - this.unit);
            if ((connectedFlags & 2) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x10) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x22) != 0 && (connectedFlags | 2 | 0x20 | 0x2000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yPos - this.unit, zNeg + this.unit, xPos, yPos, zPos - this.unit);
            if ((connectedFlags & 2) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x20) != 0) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x14) != 0 && (connectedFlags | 4 | 0x10 | 0x4000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yNeg + this.unit, zNeg, xNeg + this.unit, yPos - this.unit, zNeg + this.unit);
            if ((connectedFlags & 4) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x10) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x24) != 0 && (connectedFlags | 4 | 0x20 | 0x8000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg + this.unit, zNeg, xPos, yPos - this.unit, zNeg + this.unit);
            if ((connectedFlags & 4) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x20) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x18) != 0 && (connectedFlags | 8 | 0x10 | 0x10000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yNeg + this.unit, zPos - this.unit, xNeg + this.unit, yPos - this.unit, zPos);
            if ((connectedFlags & 8) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x10) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x28) != 0 && (connectedFlags | 8 | 0x20 | 0x20000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg + this.unit, zPos - this.unit, xPos, yPos - this.unit, zPos);
            if ((connectedFlags & 8) != 0) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags & 0x20) != 0) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x15) != 0 && (connectedFlags | 1 | 4 | 0x10 | 0x40 | 0x100 | 0x4000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yNeg, zNeg, xNeg + this.unit, yNeg + this.unit, zNeg + this.unit);
            if ((connectedFlags | 1 | 4) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 1 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 4 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x25) != 0 && (connectedFlags | 1 | 4 | 0x20 | 0x40 | 0x200 | 0x8000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg, zNeg, xPos, yNeg + this.unit, zNeg + this.unit);
            if ((connectedFlags | 1 | 4) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 1 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 4 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x19) != 0 && (connectedFlags | 1 | 8 | 0x10 | 0x80 | 0x100 | 0x10000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yNeg, zPos - this.unit, xNeg + this.unit, yNeg + this.unit, zPos);
            if ((connectedFlags | 1 | 8) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 1 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 8 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x29) != 0 && (connectedFlags | 1 | 8 | 0x20 | 0x80 | 0x200 | 0x20000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yNeg, zPos - this.unit, xPos, yNeg + this.unit, zPos);
            if ((connectedFlags | 1 | 8) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 1 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 8 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x16) != 0 && (connectedFlags | 2 | 4 | 0x10 | 0x400 | 0x1000 | 0x4000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yPos - this.unit, zNeg, xNeg + this.unit, yPos, zNeg + this.unit);
            if ((connectedFlags | 2 | 4) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 2 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 4 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x26) != 0 && (connectedFlags | 2 | 4 | 0x20 | 0x400 | 0x2000 | 0x8000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yPos - this.unit, zNeg, xPos, yPos, zNeg + this.unit);
            if ((connectedFlags | 2 | 4) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 2 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 4 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x1A) != 0 && (connectedFlags | 2 | 8 | 0x10 | 0x800 | 0x1000 | 0x10000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xNeg, yPos - this.unit, zPos - this.unit, xNeg + this.unit, yPos, zPos);
            if ((connectedFlags | 2 | 8) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
            }
            if ((connectedFlags | 2 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 8 | 0x10) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
        if ((connectedFlags & 0x2A) != 0 && (connectedFlags | 2 | 8 | 0x20 | 0x800 | 0x2000 | 0x20000) != connectedFlags) {
            this.renderHelper.setRenderBounds(xPos - this.unit, yPos - this.unit, zPos - this.unit, xPos, yPos, zPos);
            if ((connectedFlags | 2 | 8) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 2 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
            }
            if ((connectedFlags | 8 | 0x20) == connectedFlags) {
                this.renderInteriorFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
            }
        }
    }

    private void renderFace(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite icon, float r, float g, float b) {
        switch (face.func_176745_a()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                this.renderHelper.renderFace(face, blockAccess, state, pos, icon, r, g, b);
                break;
            }
            case 2: 
            case 5: {
                this.renderHelper.state.flipTexture = this.flipOpposite;
                this.renderHelper.renderFace(face, blockAccess, state, pos, icon, r, g, b);
                this.renderHelper.state.flipTexture = false;
            }
        }
    }

    private void renderExteriorFace(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        int index = face.func_176745_a();
        this.renderFace(face, blockAccess, state, pos, this.exteriorIcon[index], this.exteriorColor[index][0], this.exteriorColor[index][1], this.exteriorColor[index][2]);
    }

    private void renderInteriorFace(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        int index = face.func_176745_a();
        TextureAtlasSprite icon = this.interiorIcon[index];
        float r = this.interiorColor[index][0];
        float g = this.interiorColor[index][1];
        float b = this.interiorColor[index][2];
        this.renderFace(face, blockAccess, state, pos, icon, r, g, b);
    }

    private void renderCutFace(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        int index = face.func_176745_a();
        this.renderFace(face, blockAccess, state, pos, this.cutIcon[index], this.cutColor[index][0], this.cutColor[index][1], this.cutColor[index][2]);
    }
}

