/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.CapabilityBlockProvider;
import com.direwolf20.buildinggadgets.common.building.Context;
import com.direwolf20.buildinggadgets.common.building.IBlockProvider;
import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IBuildingMode {
    public IPlacementSequence computeCoordinates(EntityPlayer var1, BlockPos var2, EnumFacing var3, ItemStack var4);

    default public IBlockProvider getBlockProvider(ItemStack tool) {
        IBlockProvider capability = (IBlockProvider)tool.getCapability(CapabilityBlockProvider.BLOCK_PROVIDER, null);
        if (capability != null) {
            return capability;
        }
        return CapabilityBlockProvider.DEFAULT_AIR_PROVIDER;
    }

    public BiPredicate<BlockPos, IBlockState> createValidatorFor(World var1, ItemStack var2, EntityPlayer var3, BlockPos var4);

    default public Context createExecutionContext(EntityPlayer player, BlockPos hit, EnumFacing sideHit, ItemStack tool) {
        return new Context(this.computeCoordinates(player, hit, sideHit, tool), this.getBlockProvider(tool), this::createValidatorFor);
    }

    public ResourceLocation getRegistryName();

    default public String getTranslationKey() {
        return "modes." + this.getRegistryName();
    }

    default public String getLocalized() {
        return I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }
}

