/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.rendering;

import net.darkhax.bookshelf.client.model.ModelPlayerMob;
import net.darkhax.bookshelf.entity.EntityPlayerMob;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class RenderPlayerMob<T extends EntityPlayerMob>
extends RenderLiving<T> {
    private GlStateManager.Profile blendProfile;

    public RenderPlayerMob(RenderManager renderManager, ModelPlayerMob model) {
        super(renderManager, (ModelBase)model, 0.5f);
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerCustomHead(this.getMainModel().field_78116_c));
        this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
        this.blendProfile = GlStateManager.Profile.PLAYER_SKIN;
    }

    public void setBlendProfile(GlStateManager.Profile profile) {
        this.blendProfile = profile;
    }

    public ModelPlayerMob getMainModel() {
        return (ModelPlayerMob)super.func_177087_b();
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean hasProfile;
        double heightOffset = y;
        if (entity.func_70093_af()) {
            heightOffset = y - 0.125;
        }
        this.setModelVisibilities(entity);
        boolean bl = hasProfile = this.blendProfile != null;
        if (hasProfile) {
            GlStateManager.func_187408_a((GlStateManager.Profile)this.blendProfile);
        }
        super.func_76986_a(entity, x, heightOffset, z, entityYaw, partialTicks);
        if (hasProfile) {
            GlStateManager.func_187440_b((GlStateManager.Profile)this.blendProfile);
        }
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected void preRenderCallback(T entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    public void setModelVisibilities(T entity) {
        ModelPlayerMob model = this.getMainModel();
        ItemStack mainhand = entity.func_184614_ca();
        ItemStack offhand = entity.func_184592_cb();
        model.func_178719_a(true);
        this.setOverlayVisibility(entity, model);
        model.field_78117_n = entity.func_70093_af();
        ModelBiped.ArmPose mainArm = this.getPoseForStack(entity, mainhand);
        ModelBiped.ArmPose offhandArm = this.getPoseForStack(entity, offhand);
        boolean isRightHanded = entity.func_184591_cq() == EnumHandSide.RIGHT;
        model.field_187076_m = isRightHanded ? mainArm : offhandArm;
        model.field_187075_l = isRightHanded ? offhandArm : mainArm;
    }

    public void setOverlayVisibility(T entity, ModelPlayerMob model) {
        model.field_178720_f.field_78806_j = true;
        model.bodyOverlay.field_78806_j = true;
        model.leftLegOverlay.field_78806_j = true;
        model.rightLegLverlay.field_78806_j = true;
        model.leftArmOverlay.field_78806_j = true;
        model.rightArmOverlay.field_78806_j = true;
    }

    public ModelBiped.ArmPose getPoseForStack(T entity, ItemStack stack) {
        ModelBiped.ArmPose pose = ModelBiped.ArmPose.EMPTY;
        if (!stack.func_190926_b()) {
            pose = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0) {
                EnumAction actionType = stack.func_77975_n();
                pose = actionType == EnumAction.BLOCK ? ModelBiped.ArmPose.BLOCK : (actionType == EnumAction.BOW ? ModelBiped.ArmPose.BOW_AND_ARROW : ModelBiped.ArmPose.EMPTY);
            }
        }
        return pose;
    }
}

