/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.rewards;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.rewards.PanelRewardScoreboard;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.rewards.factory.FactoryRewardScoreboard;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class RewardScoreboard
implements IReward {
    public String score = "Reputation";
    public String type = "dummy";
    public boolean relative = true;
    public int value = 1;

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryRewardScoreboard.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.reward.scoreboard";
    }

    @Override
    public boolean canClaim(EntityPlayer player, DBEntry<IQuest> quest) {
        return true;
    }

    @Override
    public void claimReward(EntityPlayer player, DBEntry<IQuest> quest) {
        Scoreboard board = player.func_96123_co();
        ScoreObjective scoreObj = board.func_96518_b(this.score);
        if (scoreObj == null) {
            try {
                IScoreCriteria criteria = (IScoreCriteria)IScoreCriteria.field_96643_a.get(this.type);
                criteria = criteria != null ? criteria : new ScoreCriteria(this.score);
                scoreObj = board.func_96535_a(this.score, criteria);
                scoreObj.func_96681_a(this.score);
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to create score '" + this.score + "' for reward!", (Throwable)e);
            }
        }
        if (scoreObj == null || scoreObj.func_96680_c().func_96637_b()) {
            return;
        }
        Score s = board.func_96529_a(player.func_70005_c_(), scoreObj);
        if (this.relative) {
            s.func_96649_a(this.value);
        } else {
            s.func_96647_c(this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound json) {
        this.score = json.func_74779_i("score");
        this.type = json.func_74779_i("type");
        this.value = json.func_74762_e("value");
        this.relative = json.func_74767_n("relative");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("score", this.score);
        json.func_74778_a("type", "dummy");
        json.func_74768_a("value", this.value);
        json.func_74757_a("relative", this.relative);
        return json;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getRewardGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelRewardScoreboard(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getRewardEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }
}

