/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.waiter.media;

import me.lib720.caprica.vlcj.media.Media;
import me.lib720.caprica.vlcj.media.MediaEventAdapter;
import me.lib720.caprica.vlcj.media.MediaEventListener;
import me.lib720.caprica.vlcj.media.MediaParsedStatus;
import me.lib720.caprica.vlcj.media.MediaRef;
import me.lib720.caprica.vlcj.media.Meta;
import me.lib720.caprica.vlcj.media.Picture;
import me.lib720.caprica.vlcj.player.base.State;
import me.lib720.caprica.vlcj.waiter.Waiter;

public abstract class MediaWaiter<R>
extends Waiter<Media, R>
implements MediaEventListener {
    private final MediaEventListener internalListener = new InternalListener();

    protected MediaWaiter(Media component) {
        super(component);
    }

    @Override
    protected final void startListening(Media component) {
        component.events().addMediaEventListener(this.internalListener);
        component.events().addMediaEventListener(this);
    }

    @Override
    protected final void stopListening(Media component) {
        component.events().removeMediaEventListener(this.internalListener);
        component.events().removeMediaEventListener(this);
    }

    @Override
    public void mediaMetaChanged(Media media, Meta metaType) {
    }

    @Override
    public void mediaSubItemAdded(Media media, MediaRef newChild) {
    }

    @Override
    public void mediaDurationChanged(Media media, long newDuration) {
    }

    @Override
    public void mediaParsedChanged(Media media, MediaParsedStatus newStatus) {
    }

    @Override
    public void mediaFreed(Media media, MediaRef mediaFreed) {
    }

    @Override
    public void mediaStateChanged(Media media, State newState) {
    }

    @Override
    public void mediaSubItemTreeAdded(Media media, MediaRef item) {
    }

    @Override
    public void mediaThumbnailGenerated(Media media, Picture picture) {
    }

    private class InternalListener
    extends MediaEventAdapter {
        private InternalListener() {
        }

        @Override
        public void mediaStateChanged(Media media, State newState) {
            switch (newState) {
                case ENDED: {
                    MediaWaiter.super.finished();
                    break;
                }
                case ERROR: {
                    MediaWaiter.super.error();
                }
            }
        }
    }
}

