/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.component;

import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.medialist.MediaList;
import me.lib720.caprica.vlcj.medialist.MediaListRef;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.component.AudioListPlayerComponentBase;
import me.lib720.caprica.vlcj.player.component.MediaPlayerSpecs;
import me.lib720.caprica.vlcj.player.list.MediaListPlayer;

public class AudioListPlayerComponent
extends AudioListPlayerComponentBase {
    private MediaListPlayer mediaListPlayer;
    private MediaList mediaList;

    public AudioListPlayerComponent(MediaPlayerFactory mediaPlayerFactory) {
        super(mediaPlayerFactory);
        this.applyMediaList();
        this.onAfterConstruct();
    }

    public AudioListPlayerComponent(MediaPlayerSpecs.AudioPlayerSpec spec) {
        this(spec.factory);
    }

    public AudioListPlayerComponent() {
        this((MediaPlayerFactory)null);
    }

    @Override
    protected final MediaPlayer onCreateMediaPlayer() {
        this.mediaListPlayer = this.mediaPlayerFactory().mediaPlayers().newMediaListPlayer();
        this.mediaListPlayer.events().addMediaListPlayerEventListener(this);
        this.mediaList = this.mediaPlayerFactory().media().newMediaList();
        this.mediaList.events().addMediaListEventListener(this);
        return this.mediaPlayerFactory().mediaPlayers().newMediaPlayer(this.mediaListPlayer);
    }

    private void applyMediaList() {
        MediaListRef mediaListRef = this.mediaList.newMediaListRef();
        try {
            this.mediaListPlayer.list().setMediaList(mediaListRef);
        }
        finally {
            mediaListRef.release();
        }
    }

    public final MediaListPlayer mediaListPlayer() {
        return this.mediaListPlayer;
    }

    @Override
    protected final void onBeforeRelease() {
        this.mediaListPlayer.release();
        this.mediaList.release();
    }
}

