/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.discovery.strategy;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.io.File;
import me.lib720.caprica.vlcj.VideoLan4J;
import me.lib720.caprica.vlcj.binding.lib.LibC;
import me.lib720.caprica.vlcj.discovery.provider.DirectoryProviderDiscoveryStrategy;

public class OsxNativeDiscoveryStrategy
extends DirectoryProviderDiscoveryStrategy {
    private static final String[] FILENAME_PATTERNS = new String[]{"libvlc\\.dylib", "libvlccore\\.dylib"};
    private static final String[] PLUGIN_PATH_FORMATS = new String[]{"%s/../plugins"};

    public OsxNativeDiscoveryStrategy() {
        super(FILENAME_PATTERNS, PLUGIN_PATH_FORMATS);
    }

    @Override
    public boolean supported() {
        return Platform.isMac();
    }

    @Override
    public boolean onFound(String path) {
        try {
            if (new File("config/watermedia/macos_no_forceload.dummy").exists()) {
                return true;
            }
            this.forceLoadLibVlcCore(path);
        }
        catch (Error e) {
            return false;
        }
        return true;
    }

    private void forceLoadLibVlcCore(String path) {
        NativeLibrary.addSearchPath((String)VideoLan4J.LIBVLCCORE_NAME, (String)path);
        NativeLibrary.getInstance((String)VideoLan4J.LIBVLCCORE_NAME);
    }

    @Override
    protected boolean setPluginPath(String pluginPath) {
        return LibC.INSTANCE.setenv("VLC_PLUGIN_PATH", pluginPath, 1) == 0;
    }
}

