/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import me.srrapero720.watermedia.api.network.twitch.TwitchAPI;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;

public class TwitchFixer
extends URLFixer {
    @Override
    public String platform() {
        return "Twitch";
    }

    @Override
    public boolean isValid(URL url) {
        return (url.getHost().equals("www.twitch.tv") || url.getHost().equals("twitch.tv")) && url.getPath().startsWith("/");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality preferQuality) throws URLFixer.FixingURLException {
        super.patch(url, preferQuality);
        try {
            String path = url.getPath();
            if (path.startsWith("/videos/")) {
                return new URLFixer.Result(new URL(TwitchAPI.getVod(path.substring(8)).get(0).getUrl()), true, false);
            }
            return new URLFixer.Result(new URL(TwitchAPI.getStream(path.substring(1)).get(0).getUrl()), true, true);
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url, (Throwable)e);
        }
    }

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }
}

