/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.player.vlc;

import java.awt.Dimension;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.player.SyncBasePlayer;
import me.srrapero720.watermedia.api.rendering.RenderAPI;
import me.srrapero720.watermedia.core.annotations.Experimental;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL21;

@Experimental
public class VideoPlayer
extends SyncBasePlayer {
    private static final Marker IT = MarkerManager.getMarker((String)"VideoPlayer");
    private final int texture;
    private final int pbo;
    private volatile int width = 1;
    private volatile int height = 1;
    private ByteBuffer buffer;
    private ByteBuffer pboBuffer;
    private volatile Throwable exception;
    private final BufferHelper bufferHelper;
    protected final Executor playerThreadEx;
    protected final ReentrantLock renderLock = new ReentrantLock();
    protected final AtomicBoolean updateFrame = new AtomicBoolean(false);
    protected final AtomicBoolean updateFirstFrame = new AtomicBoolean(false);
    protected final AtomicBoolean forceFirstFrame = new AtomicBoolean(false);
    public static final BufferHelper DEFAULT_BUFFER_HELPER = RenderAPI::createByteBuffer;

    @Deprecated
    public VideoPlayer(Executor playerThreadEx) {
        this(null, playerThreadEx, DEFAULT_BUFFER_HELPER);
    }

    @Deprecated
    public VideoPlayer(MediaPlayerFactory factory, Executor playerThreadEx) {
        this(factory, playerThreadEx, DEFAULT_BUFFER_HELPER);
    }

    @Deprecated
    public VideoPlayer(Executor playerThreadEx, BufferHelper bufferHelper) {
        this(null, playerThreadEx, bufferHelper);
    }

    @Deprecated
    public VideoPlayer(MediaPlayerFactory factory, Executor playerThreadEx, BufferHelper bufferHelper) {
        this.playerThreadEx = playerThreadEx;
        this.texture = GL11.glGenTextures();
        this.pbo = GL15.glGenBuffers();
        this.bufferHelper = bufferHelper;
        this.init(factory, (mediaPlayer, nativeBuffers, bufferFormat) -> {
            this.renderLock.lock();
            try {
                if (this.buffer == null) {
                    return;
                }
                ((Buffer)nativeBuffers[0]).rewind();
                this.buffer.put(nativeBuffers[0]);
                ((Buffer)this.buffer).rewind();
                this.updateFrame.set(true);
            }
            catch (Throwable t) {
                if (this.exception == null) {
                    this.exception = t;
                    WaterMedia.LOGGER.fatal(IT, "Failed due process native buffers", t);
                }
            }
            finally {
                this.renderLock.unlock();
            }
        }, (sourceWidth, sourceHeight) -> {
            this.renderLock.lock();
            try {
                this.width = sourceWidth;
                this.height = sourceHeight;
                this.buffer = bufferHelper.create(sourceWidth * sourceHeight * 4);
                this.updateFrame.set(true);
                this.updateFirstFrame.set(true);
            }
            catch (Throwable t) {
                if (this.exception == null) {
                    this.exception = t;
                    WaterMedia.LOGGER.fatal(IT, "Failed due create ByteBuffer", t);
                }
            }
            finally {
                this.renderLock.unlock();
            }
            return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
        });
        if (this.raw() == null) {
            GL11.glDeleteTextures((int)this.texture);
        }
        GL15.glBindBuffer((int)35052, (int)this.pbo);
        GL15.glBufferData((int)35052, (long)((long)(this.width * this.height) * 4L), (int)35040);
        GL15.glBindBuffer((int)35052, (int)0);
    }

    @Deprecated
    public void firstFrameMode(boolean forced) {
        this.forceFirstFrame.set(forced);
    }

    public void texSubMode(boolean mode) {
        this.forceFirstFrame.set(mode);
    }

    @Deprecated
    public int prepareTexture() {
        this.preRender();
        return this.texture;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getBufferLock() {
        try {
            this.renderLock.lock();
            ByteBuffer byteBuffer = this.buffer;
            return byteBuffer;
        }
        finally {
            this.renderLock.unlock();
        }
    }

    public ReentrantLock getRenderLock() {
        return this.renderLock;
    }

    @Deprecated
    public void preRender() {
        if (this.raw() == null) {
            return;
        }
        this.renderLock.lock();
        try {
            GL15.glBindBuffer((int)35052, (int)this.pbo);
            this.pboBuffer = GL15.glMapBuffer((int)35052, (int)35001, (long)((long)(this.width * this.height) * 4L), (ByteBuffer)this.pboBuffer);
            this.pboBuffer.put(this.buffer);
            GL15.glUnmapBuffer((int)35052);
            GL11.glBindTexture((int)3553, (int)this.texture);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (long)0L);
            GL21.glBindBuffer((int)35052, (int)0);
        }
        finally {
            this.renderLock.unlock();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Deprecated
    public int getTexture() {
        return this.texture;
    }

    public int getGlTexture() {
        this.preRender();
        return this.texture;
    }

    public Dimension getDimensions() {
        if (this.raw() == null) {
            return null;
        }
        return new Dimension(this.width, this.height);
    }

    public Dimension getMediaDimensions() {
        if (this.raw() == null) {
            return null;
        }
        return this.raw().mediaPlayer().video().videoDimension();
    }

    @Override
    public void release() {
        this.playerThreadEx.execute(() -> {
            GL11.glDeleteTextures((int)this.texture);
            GL21.glDeleteBuffers((int)this.pbo);
            if (this.bufferHelper == DEFAULT_BUFFER_HELPER) {
                RenderAPI.freeByteBuffer(this.buffer);
            }
        });
        super.release();
        this.buffer = null;
    }

    @Deprecated
    public static interface BufferHelper {
        @Deprecated
        public ByteBuffer create(int var1);
    }
}

