/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.player;

import com.sun.jna.Platform;
import java.net.URL;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.media.InfoApi;
import me.lib720.caprica.vlcj.media.MediaSlavePriority;
import me.lib720.caprica.vlcj.media.MediaSlaveType;
import me.lib720.caprica.vlcj.media.MediaType;
import me.lib720.caprica.vlcj.player.base.EmbededMediaPlayerEventListener;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.base.State;
import me.lib720.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.SimpleBufferFormatCallback;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.player.PlayerAPI;
import me.srrapero720.watermedia.api.url.UrlAPI;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.core.annotations.Experimental;
import me.srrapero720.watermedia.core.tools.ThreadTool;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class SyncBasePlayer {
    protected static final Marker IT = MarkerManager.getMarker((String)"SyncMediaPlayer");
    protected static final WaterMediaPlayerEventListener LISTENER = new WaterMediaPlayerEventListener();
    protected volatile URL url;
    protected volatile URL audioUrl;
    private volatile CallbackMediaPlayerComponent raw;
    protected volatile boolean live = false;
    protected volatile boolean started = false;

    public CallbackMediaPlayerComponent raw() {
        return this.raw;
    }

    public void submit(Runnable r) {
        if (this.raw != null) {
            this.raw.mediaPlayer().submit(r);
        }
    }

    protected SyncBasePlayer(MediaPlayerFactory factory, RenderCallback renderCallback, SimpleBufferFormatCallback bufferFormatCallback) {
        this.init(factory, renderCallback, bufferFormatCallback);
    }

    protected SyncBasePlayer() {
    }

    protected void init(MediaPlayerFactory factory, RenderCallback renderCallback, SimpleBufferFormatCallback bufferFormatCallback) {
        if (PlayerAPI.isReady() && this.raw == null) {
            if (factory == null) {
                factory = PlayerAPI.getFactory();
            }
            this.raw = new CallbackMediaPlayerComponent(factory, false, renderCallback, bufferFormatCallback);
            this.raw.mediaPlayer().events().addMediaPlayerEventListener(LISTENER);
        } else {
            WaterMedia.LOGGER.error(IT, "Failed to create raw player because VLC is not loaded");
            this.raw = null;
        }
    }

    private boolean rpa(CharSequence url) {
        if (this.raw == null) {
            return false;
        }
        try {
            URLFixer.Result result = UrlAPI.fixURL(url.toString());
            if (result == null) {
                throw new IllegalArgumentException("Invalid URL");
            }
            this.url = result.url;
            this.audioUrl = result.audioUrl;
            this.live = result.assumeStream;
            return true;
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to load player", (Throwable)e);
            return false;
        }
    }

    public void start(CharSequence url) {
        this.start(url, new String[0]);
    }

    public void start(CharSequence url, String[] vlcArgs) {
        this.started = false;
        Runnable action = () -> {
            if (this.rpa(url)) {
                if (this.audioUrl != null) {
                    this.raw.mediaPlayer().media().prepare(this.url, vlcArgs);
                    this.raw.mediaPlayer().media().slaves().add(MediaSlaveType.AUDIO, MediaSlavePriority.HIGHEST, this.audioUrl.toString());
                    this.raw.mediaPlayer().controls().start();
                } else {
                    this.raw.mediaPlayer().media().start(this.url, vlcArgs);
                }
            }
            this.started = true;
        };
        if (Platform.isMac()) {
            action.run();
        } else {
            ThreadTool.thread(4, action);
        }
    }

    public void startPaused(CharSequence url) {
        this.startPaused(url, new String[0]);
    }

    public void startPaused(CharSequence url, String[] vlcArgs) {
        this.started = false;
        Runnable action = () -> {
            if (this.rpa(url)) {
                if (this.audioUrl != null) {
                    this.raw.mediaPlayer().media().prepare(this.url, vlcArgs);
                    if (!this.raw.mediaPlayer().media().slaves().add(MediaSlaveType.AUDIO, MediaSlavePriority.HIGHEST, this.audioUrl.toString())) {
                        WaterMedia.LOGGER.warn(IT, "Failed to add audio slave {} for {}", (Object)this.audioUrl.toString(), (Object)this.url.toString());
                    }
                    this.raw.mediaPlayer().controls().start();
                } else {
                    this.raw.mediaPlayer().media().start(this.url, vlcArgs);
                }
            }
            this.started = true;
        };
        if (Platform.isMac()) {
            action.run();
        } else {
            ThreadTool.thread(4, action);
        }
    }

    @Deprecated
    public State getRawPlayerState() {
        if (this.raw == null) {
            return State.ERROR;
        }
        return this.raw.mediaPlayer().status().state();
    }

    public void resume() {
        this.play();
    }

    public void play() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().play();
    }

    public void pause() {
        if (this.raw == null) {
            return;
        }
        if (this.raw.mediaPlayer().status().canPause()) {
            this.raw.mediaPlayer().controls().pause();
        }
    }

    public void togglePlayback() {
        if (this.raw == null) {
            return;
        }
        if (this.isPaused()) {
            this.raw.mediaPlayer().controls().play();
        } else if (this.isPlaying()) {
            this.raw.mediaPlayer().controls().pause();
        }
    }

    public void setPauseMode(boolean pauseMode) {
        if (this.raw == null) {
            return;
        }
        if (this.raw.mediaPlayer().status().canPause()) {
            this.raw.mediaPlayer().controls().setPause(pauseMode);
        }
    }

    public void stop() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().stop();
    }

    public boolean isSafeUse() {
        return this.started;
    }

    public boolean isLoading() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.OPENING);
    }

    public boolean isBuffering() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.BUFFERING);
    }

    public boolean isReady() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().isPlayable();
    }

    public boolean isPaused() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.PAUSED);
    }

    public boolean isStopped() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.STOPPED);
    }

    public boolean isEnded() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.ENDED);
    }

    public boolean isMuted() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().audio().isMute();
    }

    public boolean isBroken() {
        if (this.raw == null) {
            return true;
        }
        return this.raw.mediaPlayer().status().state().equals((Object)State.ERROR);
    }

    public boolean isValid() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().media().isValid();
    }

    public boolean isPlaying() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().isPlaying();
    }

    @Experimental
    public boolean isLive() {
        InfoApi info;
        if (this.live) {
            return true;
        }
        if (this.url.getPath().endsWith(".m3u8") || this.url.getPath().endsWith(".m3u")) {
            if (this.getMediaInfoDuration() == -1L) {
                return true;
            }
            if (this.getTime() > this.getDuration()) {
                return true;
            }
        }
        if ((info = this.raw.mediaPlayer().media().info()) != null) {
            return info.type().equals((Object)MediaType.STREAM);
        }
        return false;
    }

    public boolean isSeekAble() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().status().isSeekable();
    }

    public void seekTo(long time) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setTime(time);
    }

    public void seekFastTo(long ticks) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setTime(ticks);
    }

    public void foward() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().skipTime(5000L);
    }

    public void rewind() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().skipTime(-5000L);
    }

    public void setSpeed(float rate) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setRate(rate);
    }

    public int getVolume() {
        if (this.raw == null) {
            return 0;
        }
        return this.raw.mediaPlayer().audio().volume();
    }

    public void setVolume(int volume) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setVolume(volume);
        if (volume == 0 && !this.raw.mediaPlayer().audio().isMute()) {
            this.raw.mediaPlayer().audio().setMute(true);
        } else if (volume > 0 && this.raw.mediaPlayer().audio().isMute()) {
            this.raw.mediaPlayer().audio().setMute(false);
        }
    }

    public void mute() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setMute(true);
    }

    public void unmute() {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setMute(false);
    }

    public void setMuteMode(boolean mode) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().audio().setMute(mode);
    }

    public long getDuration() {
        if (this.raw == null) {
            return 0L;
        }
        if (!this.isValid() || Platform.isLinux() && this.getRawPlayerState().equals((Object)State.STOPPED)) {
            return 0L;
        }
        return this.raw.mediaPlayer().status().length();
    }

    public long getMediaInfoDuration() {
        if (this.raw == null) {
            return 0L;
        }
        InfoApi info = this.raw.mediaPlayer().media().info();
        if (info != null) {
            return info.duration();
        }
        return 0L;
    }

    public long getTime() {
        if (this.raw == null) {
            return 0L;
        }
        return this.raw.mediaPlayer().status().time();
    }

    public boolean getRepeatMode() {
        if (this.raw == null) {
            return false;
        }
        return this.raw.mediaPlayer().controls().getRepeat();
    }

    public void setRepeatMode(boolean repeatMode) {
        if (this.raw == null) {
            return;
        }
        this.raw.mediaPlayer().controls().setRepeat(repeatMode);
    }

    public void release() {
        if (this.raw == null) {
            return;
        }
        ThreadTool.thread(5, () -> {
            while (!this.started) {
            }
            SyncBasePlayer syncBasePlayer = this;
            synchronized (syncBasePlayer) {
                CallbackMediaPlayerComponent rawRef = this.raw;
                this.raw = null;
                if (rawRef == null) {
                    return;
                }
                rawRef.mediaPlayer().release();
            }
        });
    }

    protected static final class WaterMediaPlayerEventListener
    extends EmbededMediaPlayerEventListener {
        protected WaterMediaPlayerEventListener() {
        }

        @Override
        public void buffering(MediaPlayer mediaPlayer, float newCache) {
            if (newCache >= 100.0f) {
                mediaPlayer.submit(() -> {
                    mediaPlayer.audio().enforceVolume();
                    int volume = mediaPlayer.audio().masterVolume();
                    if (volume == 0 && !mediaPlayer.audio().isMute()) {
                        mediaPlayer.audio().setMute(true);
                    } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                        mediaPlayer.audio().setMute(false);
                    }
                });
            }
        }

        @Override
        public void playing(MediaPlayer mediaPlayer) {
            mediaPlayer.submit(() -> {
                mediaPlayer.audio().enforceVolume();
                int volume = mediaPlayer.audio().masterVolume();
                if (volume == 0 && !mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(true);
                } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(false);
                }
            });
        }

        @Override
        public void paused(MediaPlayer mediaPlayer) {
            mediaPlayer.submit(() -> {
                mediaPlayer.audio().enforceVolume();
                int volume = mediaPlayer.audio().masterVolume();
                if (volume == 0 && !mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(true);
                } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(false);
                }
            });
        }

        @Override
        public void mediaPlayerReady(MediaPlayer mediaPlayer) {
            mediaPlayer.submit(() -> {
                mediaPlayer.audio().enforceVolume();
                int volume = mediaPlayer.audio().masterVolume();
                if (volume == 0 && !mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(true);
                } else if (volume > 0 && mediaPlayer.audio().isMute()) {
                    mediaPlayer.audio().setMute(false);
                }
            });
        }
    }
}

