/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.tukaani.xz;

import java.io.IOException;
import me.lib720.tukaani.xz.FinishableOutputStream;
import me.lib720.tukaani.xz.UnsupportedOptionsException;
import me.lib720.tukaani.xz.XZIOException;
import me.lib720.tukaani.xz.simple.SimpleFilter;

class SimpleOutputStream
extends FinishableOutputStream {
    private static final int FILTER_BUF_SIZE = 4096;
    private FinishableOutputStream out;
    private final SimpleFilter simpleFilter;
    private final byte[] filterBuf = new byte[4096];
    private int pos = 0;
    private int unfiltered = 0;
    private IOException exception = null;
    private boolean finished = false;
    private final byte[] tempBuf = new byte[1];

    static int getMemoryUsage() {
        return 5;
    }

    SimpleOutputStream(FinishableOutputStream finishableOutputStream, SimpleFilter simpleFilter) {
        if (finishableOutputStream == null) {
            throw new NullPointerException();
        }
        this.out = finishableOutputStream;
        this.simpleFilter = simpleFilter;
    }

    @Override
    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, 4096 - (this.pos + this.unfiltered));
            System.arraycopy(byArray, n, this.filterBuf, this.pos + this.unfiltered, n3);
            n += n3;
            n2 -= n3;
            this.unfiltered += n3;
            int n4 = this.simpleFilter.code(this.filterBuf, this.pos, this.unfiltered);
            assert (n4 <= this.unfiltered);
            this.unfiltered -= n4;
            try {
                this.out.write(this.filterBuf, this.pos, n4);
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.pos += n4;
            if (this.pos + this.unfiltered != 4096) continue;
            System.arraycopy(this.filterBuf, this.pos, this.filterBuf, 0, this.unfiltered);
            this.pos = 0;
        }
    }

    private void writePending() throws IOException {
        assert (!this.finished);
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            this.out.write(this.filterBuf, this.pos, this.unfiltered);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
        this.finished = true;
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOptionsException("Flushing is not supported");
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            this.writePending();
            try {
                this.out.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block7: {
                if (!this.finished) {
                    try {
                        this.writePending();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block7;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

