/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.list;

import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.player.list.BaseApi;
import me.lib720.caprica.vlcj.player.list.MediaListPlayer;
import me.lib720.caprica.vlcj.player.list.PlaybackMode;

public final class ControlsApi
extends BaseApi {
    ControlsApi(MediaListPlayer mediaListPlayer) {
        super(mediaListPlayer);
    }

    public void play() {
        this.attachVideoSurface();
        LibVlc.libvlc_media_list_player_play(this.mediaListPlayerInstance);
    }

    public void pause() {
        LibVlc.libvlc_media_list_player_pause(this.mediaListPlayerInstance);
    }

    public void setPause(boolean pause) {
        LibVlc.libvlc_media_list_player_set_pause(this.mediaListPlayerInstance, pause ? 1 : 0);
    }

    public void stop() {
        LibVlc.libvlc_media_list_player_stop(this.mediaListPlayerInstance);
    }

    public boolean play(int itemIndex) {
        this.attachVideoSurface();
        return LibVlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayerInstance, itemIndex) == 0;
    }

    public boolean playNext() {
        this.attachVideoSurface();
        return LibVlc.libvlc_media_list_player_next(this.mediaListPlayerInstance) == 0;
    }

    public boolean playPrevious() {
        this.attachVideoSurface();
        return LibVlc.libvlc_media_list_player_previous(this.mediaListPlayerInstance) == 0;
    }

    public boolean setMode(PlaybackMode mode) {
        if (mode != null) {
            LibVlc.libvlc_media_list_player_set_playback_mode(this.mediaListPlayerInstance, mode.intValue());
            return true;
        }
        return false;
    }

    private void attachVideoSurface() {
        this.mediaListPlayer.mediaPlayer().attachVideoSurface();
    }
}

