/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.component;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.player.component.AudioListPlayerComponent;
import me.lib720.caprica.vlcj.player.component.AudioPlayerComponent;
import me.lib720.caprica.vlcj.player.component.CallbackMediaListPlayerComponent;
import me.lib720.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import me.lib720.caprica.vlcj.player.component.EmbeddedMediaListPlayerComponent;
import me.lib720.caprica.vlcj.player.component.EmbeddedMediaPlayerComponent;
import me.lib720.caprica.vlcj.player.component.InputEvents;
import me.lib720.caprica.vlcj.player.component.callback.CallbackImagePainter;
import me.lib720.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;
import me.lib720.caprica.vlcj.player.embedded.fullscreen.adaptive.AdaptiveFullScreenStrategy;
import me.lib720.caprica.vlcj.player.embedded.fullscreen.unsupported.UnsupportedFullScreenStrategy;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public final class MediaPlayerSpecs {
    public static EmbeddedMediaPlayerSpec embeddedMediaPlayerSpec() {
        return new EmbeddedMediaPlayerSpec();
    }

    public static CallbackMediaPlayerSpec callbackMediaPlayerSpec() {
        return new CallbackMediaPlayerSpec();
    }

    public static AudioPlayerSpec audioPlayerSpec() {
        return new AudioPlayerSpec();
    }

    public static final class EmbeddedMediaPlayerSpec {
        MediaPlayerFactory factory;
        Component videoSurfaceComponent;
        FullScreenStrategy fullScreenStrategy;
        InputEvents inputEvents;
        Window overlay;

        public EmbeddedMediaPlayerSpec withFactory(MediaPlayerFactory factory) {
            this.factory = factory;
            return this;
        }

        public EmbeddedMediaPlayerSpec withVideoSurfaceComponent(Component videoSurfaceComponent) {
            this.videoSurfaceComponent = videoSurfaceComponent;
            return this;
        }

        public EmbeddedMediaPlayerSpec withFullScreenStrategy(FullScreenStrategy fullScreenStrategy) {
            this.fullScreenStrategy = fullScreenStrategy;
            return this;
        }

        public EmbeddedMediaPlayerSpec withDefaultFullScreenStrategy(Window fullScreenWindow) {
            this.fullScreenStrategy = new AdaptiveFullScreenStrategy(fullScreenWindow);
            return this;
        }

        public EmbeddedMediaPlayerSpec withUnsupportedFullScreenStrategy() {
            this.fullScreenStrategy = new UnsupportedFullScreenStrategy();
            return this;
        }

        public EmbeddedMediaPlayerSpec withInputEvents(InputEvents inputEvents) {
            this.inputEvents = inputEvents;
            return this;
        }

        public EmbeddedMediaPlayerSpec withOverlay(Window overlay) {
            this.overlay = overlay;
            return this;
        }

        public EmbeddedMediaPlayerComponent embeddedMediaPlayer() {
            return new EmbeddedMediaPlayerComponent(this);
        }

        public EmbeddedMediaListPlayerComponent embeddedMediaListPlayer() {
            return new EmbeddedMediaListPlayerComponent(this);
        }

        private EmbeddedMediaPlayerSpec() {
        }
    }

    public static final class CallbackMediaPlayerSpec {
        MediaPlayerFactory factory;
        FullScreenStrategy fullScreenStrategy;
        InputEvents inputEvents;
        boolean lockedBuffers = true;
        CallbackImagePainter imagePainter;
        RenderCallback renderCallback;
        BufferFormatCallback bufferFormatCallback;
        JComponent videoSurfaceComponent;

        public CallbackMediaPlayerSpec withFactory(MediaPlayerFactory factory) {
            this.factory = factory;
            return this;
        }

        public CallbackMediaPlayerSpec withFullScreenStrategy(FullScreenStrategy fullScreenStrategy) {
            this.fullScreenStrategy = fullScreenStrategy;
            return this;
        }

        public CallbackMediaPlayerSpec withDefaultFullScreenStrategy(Window fullScreenWindow) {
            this.fullScreenStrategy = new AdaptiveFullScreenStrategy(fullScreenWindow);
            return this;
        }

        public CallbackMediaPlayerSpec withUnsupportedFullScreenStrategy() {
            this.fullScreenStrategy = new UnsupportedFullScreenStrategy();
            return this;
        }

        public CallbackMediaPlayerSpec withInputEvents(InputEvents inputEvents) {
            this.inputEvents = inputEvents;
            return this;
        }

        public CallbackMediaPlayerSpec withLockedBuffers(boolean lockedBuffers) {
            this.lockedBuffers = lockedBuffers;
            return this;
        }

        public CallbackMediaPlayerSpec withLockedBuffers() {
            this.lockedBuffers = true;
            return this;
        }

        public CallbackMediaPlayerSpec withImagePainter(CallbackImagePainter imagePainter) {
            this.imagePainter = imagePainter;
            return this;
        }

        public CallbackMediaPlayerSpec withRenderCallback(RenderCallback renderCallback) {
            this.renderCallback = renderCallback;
            return this;
        }

        public CallbackMediaPlayerSpec withBufferFormatCallback(BufferFormatCallback bufferFormatCallback) {
            this.bufferFormatCallback = bufferFormatCallback;
            return this;
        }

        public CallbackMediaPlayerSpec withVideoSurfaceComponent(JComponent videoSurfaceComponent) {
            this.videoSurfaceComponent = videoSurfaceComponent;
            return this;
        }

        public CallbackMediaPlayerComponent callbackMediaPlayer() {
            return new CallbackMediaPlayerComponent(this);
        }

        public CallbackMediaListPlayerComponent callbackMediaListPlayer() {
            return new CallbackMediaListPlayerComponent(this);
        }

        private CallbackMediaPlayerSpec() {
        }
    }

    public static final class AudioPlayerSpec {
        MediaPlayerFactory factory;

        public AudioPlayerSpec withFactory(MediaPlayerFactory factory) {
            this.factory = factory;
            return this;
        }

        public AudioPlayerComponent audioPlayer() {
            return new AudioPlayerComponent(this);
        }

        public AudioListPlayerComponent audioListPlayer() {
            return new AudioListPlayerComponent(this);
        }

        private AudioPlayerSpec() {
        }
    }
}

