/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import java.awt.Color;
import me.lib720.caprica.vlcj.player.base.MarqueePosition;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;

public final class Marquee {
    private String text;
    private Color colour;
    private Integer rgb;
    private Integer intOpacity;
    private Float floatOpacity;
    private Integer size;
    private Integer timeout;
    private Integer x;
    private Integer y;
    private MarqueePosition position;
    private Integer refresh;
    private boolean enable;

    public static Marquee marquee() {
        return new Marquee();
    }

    private Marquee() {
    }

    public Marquee text(String text) {
        this.text = text;
        return this;
    }

    public Marquee colour(Color colour) {
        this.colour = colour;
        return this;
    }

    public Marquee colour(int rgb) {
        this.rgb = rgb;
        return this;
    }

    public Marquee opacity(int opacity) {
        this.intOpacity = opacity;
        return this;
    }

    public Marquee opacity(float opacity) {
        this.floatOpacity = Float.valueOf(opacity);
        return this;
    }

    public Marquee size(int size) {
        this.size = size;
        return this;
    }

    public Marquee timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Marquee location(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Marquee position(MarqueePosition position) {
        this.position = position;
        return this;
    }

    public Marquee refresh(int refresh) {
        this.refresh = refresh;
        return this;
    }

    public Marquee enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public Marquee enable() {
        this.enable = true;
        return this;
    }

    public Marquee disable() {
        this.enable = false;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Color getColour() {
        return this.colour;
    }

    public Integer getRgb() {
        return this.rgb;
    }

    public Integer getIntegerOpacity() {
        return this.intOpacity;
    }

    public Float getFloatOpacity() {
        return this.floatOpacity;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    public MarqueePosition getPosition() {
        return this.position;
    }

    public Integer getRefresh() {
        return this.refresh;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void apply(MediaPlayer mediaPlayer) {
        if (this.text != null) {
            mediaPlayer.marquee().setText(this.text);
        }
        if (this.colour != null) {
            mediaPlayer.marquee().setColour(this.colour);
        }
        if (this.rgb != null) {
            mediaPlayer.marquee().setColour(this.rgb);
        }
        if (this.intOpacity != null) {
            mediaPlayer.marquee().setOpacity(this.intOpacity);
        }
        if (this.floatOpacity != null) {
            mediaPlayer.marquee().setOpacity(this.floatOpacity.floatValue());
        }
        if (this.size != null) {
            mediaPlayer.marquee().setSize(this.size);
        }
        if (this.timeout != null) {
            mediaPlayer.marquee().setTimeout(this.timeout);
        }
        if (this.x != null && this.y != null && this.x >= 0 && this.y >= 0) {
            mediaPlayer.marquee().setLocation(this.x, this.y);
        }
        if (this.position != null) {
            mediaPlayer.marquee().setPosition(this.position);
        }
        if (this.refresh != null) {
            mediaPlayer.marquee().setRefresh(this.refresh);
        }
        if (this.enable) {
            mediaPlayer.marquee().enable(true);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "text=" + this.text + ',' + "colour=" + this.colour + ',' + "rgb=" + this.rgb + ',' + "intOpacity=" + this.intOpacity + ',' + "floatOpacity=" + this.floatOpacity + ',' + "size=" + this.size + ',' + "timeout=" + this.timeout + ',' + "x=" + this.x + ',' + "y=" + this.y + ',' + "position=" + (Object)((Object)this.position) + ',' + "refresh=" + this.refresh + ',' + "enable=" + this.enable + ']';
    }
}

