/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import me.srrapero720.watermedia.api.image.ImageCache;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;

public class WidgetStatusIcon
extends GuiIcon {
    private final DisplayTile tile;

    public WidgetStatusIcon(String name, Icon icon, DisplayTile tile) {
        super(name, icon);
        this.tile = tile;
    }

    public void tick() {
        if (!this.isClient()) {
            return;
        }
        this.setTooltip(this.getStatusTooltip());
        this.setIcon(this.getStatusIcon());
        super.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getStatusTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!this.tile.data.active) {
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{ChatFormatting.RED + WidgetStatusIcon.translate((String)"waterframes.status.off")}));
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status.off.desc"));
            return tooltip;
        }
        if (this.tile.imageCache == null) {
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{ChatFormatting.RED + WidgetStatusIcon.translate((String)"waterframes.status.failed")}));
            return tooltip;
        }
        String status = switch (this.tile.imageCache.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ImageCache.Status.READY -> ChatFormatting.GREEN + WidgetStatusIcon.translate((String)"waterframes.status.operative");
            case ImageCache.Status.LOADING -> ChatFormatting.AQUA + WidgetStatusIcon.translate((String)"waterframes.status.loading");
            case ImageCache.Status.FAILED -> ChatFormatting.RED + WidgetStatusIcon.translate((String)"waterframes.download.exception.invalid");
            case ImageCache.Status.WAITING, ImageCache.Status.FORGOTTEN -> {
                if (this.tile.imageCache.url.isEmpty()) {
                    yield ChatFormatting.AQUA + WidgetStatusIcon.translate((String)"waterframes.status.idle");
                }
                Exception e = this.tile.imageCache.getException();
                if (e != null) {
                    yield ChatFormatting.DARK_RED + this.tile.imageCache.getException().getLocalizedMessage();
                }
                yield ChatFormatting.DARK_RED + WidgetStatusIcon.translate((String)"waterframes.status.not_working");
            }
        };
        tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{status}));
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getStatusIcon() {
        if (!this.tile.data.active) {
            return IconStyles.STATUS_OFF;
        }
        if (this.tile.imageCache == null) {
            return IconStyles.STATUS_ERROR;
        }
        return switch (this.tile.imageCache.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ImageCache.Status.READY -> IconStyles.STATUS_OK;
            case ImageCache.Status.LOADING -> IconStyles.STATUS_WARN;
            case ImageCache.Status.FAILED -> IconStyles.STATUS_ERROR;
            case ImageCache.Status.WAITING, ImageCache.Status.FORGOTTEN -> this.tile.imageCache.url.isEmpty() ? IconStyles.STATUS_IDLE : IconStyles.STATUS_ERROR;
        };
    }
}

