/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WFRegistry;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.compat.valkyrienskies.VSCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="waterframes")
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="waterframes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WaterFrames {
    public static final String ID = "waterframes";
    public static final String NAME = "WATERFrAMES";
    public static final Logger LOGGER = LogManager.getLogger((String)"waterframes");
    public static final ResourceLocation LOADING_ANIMATION = WaterFrames.asResource("loading_animation");
    public static final long SYNC_TIME = 1000L;
    private static long ticks = 0L;

    public WaterFrames() {
        WFConfig.init();
        WFRegistry.init(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static ResourceLocation asResource(String id) {
        return new ResourceLocation(ID, id);
    }

    public static ResourceLocation asResource(int texture) {
        return new ResourceLocation(ID, "dynamic_texture_" + texture);
    }

    public static boolean isInstalled(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static boolean isInstalled(String ... mods) {
        for (String id : mods) {
            if (FMLLoader.getLoadingModList().getModFileById(id) != null) continue;
            return false;
        }
        return true;
    }

    public static double getDistance(DisplayTile tile, Position playerPos) {
        return WaterFrames.getDistance(tile.f_58857_, tile.m_58899_(), playerPos);
    }

    public static double getDistance(Level level, BlockPos pos, Position position) {
        if (VSCompat.installed() && WFConfig.vsEurekaCompat()) {
            return Math.sqrt(VSCompat.getSquaredDistance(level, pos, position));
        }
        return Math.sqrt(pos.m_203202_(position.m_7096_(), position.m_7098_(), position.m_7094_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float deltaFrames() {
        return Minecraft.m_91087_().m_91104_() ? 1.0f : Minecraft.m_91087_().m_91296_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        if (++ticks == Long.MAX_VALUE) {
            ticks = 0L;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static long getTicks() {
        return ticks;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WaterFrames.tick();
        }
    }
}

