/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.display;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.Executor;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WFRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.DisplayList;
import me.srrapero720.waterframes.client.rendering.TextureWrapper;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.watermedia.api.image.ImageCache;
import me.srrapero720.watermedia.api.math.MathAPI;
import me.srrapero720.watermedia.api.player.SyncVideoPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@OnlyIn(value=Dist.CLIENT)
public class Display {
    private static final Marker IT = MarkerManager.getMarker((String)"Display");
    private static final Int2ObjectOpenHashMap<ResourceLocation> TEXTURES = new Int2ObjectOpenHashMap();
    private SyncVideoPlayer mediaPlayer;
    private final ImageCache imageCache;
    private final DisplayTile tile;
    private int currentVolume = 0;
    private long currentLastTime = Long.MIN_VALUE;
    private Mode displayMode = Mode.PICTURE;
    private boolean stream = false;
    private boolean synced = false;
    private boolean released = false;

    public Display(DisplayTile tile) {
        this.tile = tile;
        this.imageCache = tile.imageCache;
        if (this.imageCache.isVideo()) {
            this.switchVideoMode();
        } else {
            this.imageCache.addOnReleaseListener(renderer -> {
                for (int tex : renderer.textures) {
                    WFRegistry.unregisterTexture((ResourceLocation)TEXTURES.remove(tex));
                }
            });
        }
    }

    private void switchVideoMode() {
        if (!WFConfig.useMultimedia()) {
            this.displayMode = Mode.PICTURE;
            return;
        }
        this.displayMode = Mode.VIDEO;
        this.mediaPlayer = new SyncVideoPlayer((Executor)Minecraft.m_91087_());
        if (this.mediaPlayer.isBroken()) {
            this.displayMode = Mode.PICTURE;
            return;
        }
        this.currentVolume = this.rangedVol(this.tile.data.volume, this.tile.data.minVolumeDistance, this.tile.data.maxVolumeDistance);
        this.mediaPlayer.setVolume(this.currentVolume);
        this.mediaPlayer.setRepeatMode(this.tile.data.loop);
        this.mediaPlayer.setPauseMode(this.tile.data.paused);
        this.mediaPlayer.setMuteMode(this.tile.data.muted);
        this.mediaPlayer.start((CharSequence)this.tile.data.url, new String[]{":network-caching=5000"});
        DisplayList.add(this);
    }

    public int width() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().width;
                }
                yield 1;
            }
            case Mode.VIDEO -> this.mediaPlayer.getWidth();
            case Mode.AUDIO -> 0;
        };
    }

    public int height() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().height;
                }
                yield 1;
            }
            case Mode.VIDEO -> this.mediaPlayer.getHeight();
            case Mode.AUDIO -> 0;
        };
    }

    public int texture() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> this.imageCache.getRenderer().texture(this.tile.data.tick, !this.tile.data.paused ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0L, this.tile.data.loop);
            case Mode.VIDEO -> this.mediaPlayer.getGlTexture();
            case Mode.AUDIO -> 0;
        };
    }

    public ResourceLocation getTextureId() {
        int texture = this.texture();
        if (texture != -1) {
            return (ResourceLocation)TEXTURES.computeIfAbsent((Object)texture, integer -> {
                ResourceLocation id = WaterFrames.asResource(texture);
                WFRegistry.registerTexture(id, new TextureWrapper(texture));
                return id;
            });
        }
        return null;
    }

    public int durationInTicks() {
        return MathAPI.msToTick((long)this.duration());
    }

    public long duration() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().duration;
                }
                yield 0L;
            }
            case Mode.VIDEO -> this.mediaPlayer.getDuration();
            case Mode.AUDIO -> 0L;
        };
    }

    public boolean canTick() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> this.imageCache.getStatus().equals((Object)ImageCache.Status.READY);
            case Mode.VIDEO -> {
                if (this.mediaPlayer.isSafeUse() && this.mediaPlayer.isValid()) {
                    yield true;
                }
                yield false;
            }
            case Mode.AUDIO -> this.mediaPlayer.isSafeUse();
        };
    }

    public boolean canRender() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getStatus() == ImageCache.Status.READY && !this.imageCache.isVideo() && this.tile.data.active) {
                    yield true;
                }
                yield false;
            }
            case Mode.VIDEO -> {
                if (this.mediaPlayer.isValid() && this.tile.data.active) {
                    yield true;
                }
                yield false;
            }
            case Mode.AUDIO -> false;
        };
    }

    public void syncDuration() {
        if (this.tile.data.tickMax == -1L) {
            this.tile.data.tick = 0L;
        }
        this.tile.syncTime(true, this.tile.data.tick, this.durationInTicks());
    }

    public void tick() {
        switch (this.displayMode) {
            case PICTURE: {
                if (!this.imageCache.isVideo()) break;
                this.switchVideoMode();
                break;
            }
            case VIDEO: 
            case AUDIO: {
                boolean mayPause;
                int volume = this.rangedVol(this.tile.data.volume, this.tile.data.minVolumeDistance, this.tile.data.maxVolumeDistance);
                if (this.currentVolume != volume) {
                    this.currentVolume = volume;
                    this.mediaPlayer.setVolume(this.currentVolume);
                }
                if (!this.mediaPlayer.isSafeUse() || !this.mediaPlayer.isValid()) break;
                if (this.mediaPlayer.getRepeatMode() != this.tile.data.loop) {
                    this.mediaPlayer.setRepeatMode(this.tile.data.loop);
                }
                if (this.mediaPlayer.isMuted() != this.tile.data.muted) {
                    this.mediaPlayer.setMuteMode(this.tile.data.muted);
                }
                if (!this.stream && this.mediaPlayer.isLive()) {
                    this.stream = true;
                }
                boolean bl = mayPause = this.tile.data.paused || !this.tile.data.active || Minecraft.m_91087_().m_91104_();
                if (this.mediaPlayer.isPaused() != mayPause) {
                    this.mediaPlayer.setPauseMode(mayPause);
                }
                if (this.stream || !this.mediaPlayer.isSeekAble()) break;
                long time = MathAPI.tickToMs((long)this.tile.data.tick) + (!mayPause ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0L);
                if (time > this.mediaPlayer.getTime() && this.tile.data.loop) {
                    long mediaDuration = this.mediaPlayer.getMediaInfoDuration();
                    long l = time = time == 0L || mediaDuration == 0L ? 0L : Math.floorMod(time, this.mediaPlayer.getMediaInfoDuration());
                }
                if (Math.abs(time - this.mediaPlayer.getTime()) <= 1000L || Math.abs(time - this.currentLastTime) <= 1000L) break;
                this.currentLastTime = time;
                this.mediaPlayer.seekTo(time);
            }
        }
        if (!this.synced && this.canRender()) {
            this.syncDuration();
            this.synced = true;
        }
    }

    public boolean isReady() {
        if (this.imageCache.getStatus() != ImageCache.Status.READY) {
            return false;
        }
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> true;
            case Mode.VIDEO, Mode.AUDIO -> this.imageCache.getStatus() == ImageCache.Status.READY && this.mediaPlayer.isReady();
        };
    }

    public boolean isBuffering() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> false;
            case Mode.VIDEO, Mode.AUDIO -> this.mediaPlayer.isBuffering() || this.mediaPlayer.isLoading();
        };
    }

    public boolean isBroken() {
        if (this.imageCache.getStatus() == ImageCache.Status.FAILED) {
            return true;
        }
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> false;
            case Mode.VIDEO, Mode.AUDIO -> this.mediaPlayer.isBroken();
        };
    }

    public boolean isLoading() {
        if (this.imageCache.getStatus() == ImageCache.Status.LOADING) {
            return true;
        }
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> false;
            case Mode.VIDEO, Mode.AUDIO -> this.mediaPlayer.isLoading();
        };
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setPauseMode(boolean pause) {
        switch (this.displayMode) {
            case PICTURE: {
                break;
            }
            case VIDEO: 
            case AUDIO: {
                this.mediaPlayer.seekTo(MathAPI.tickToMs((long)this.tile.data.tick));
                this.mediaPlayer.setPauseMode(pause);
                this.mediaPlayer.setMuteMode(this.tile.data.muted);
            }
        }
    }

    public void setMuteMode(boolean mute) {
        switch (this.displayMode) {
            case PICTURE: {
                break;
            }
            case VIDEO: 
            case AUDIO: {
                this.mediaPlayer.setMuteMode(mute);
            }
        }
    }

    public void release() {
        if (this.isReleased()) {
            return;
        }
        this.released = true;
        this.imageCache.deuse();
        switch (this.displayMode) {
            case PICTURE: {
                break;
            }
            case VIDEO: 
            case AUDIO: {
                this.mediaPlayer.release();
                WFRegistry.unregisterTexture((ResourceLocation)TEXTURES.remove(this.mediaPlayer.getTexture()));
                DisplayList.remove(this);
            }
        }
    }

    public int rangedVol(int volume, int min, int max) {
        double distance = WaterFrames.getDistance(this.tile.f_58857_, this.tile.m_58899_().m_5484_(this.tile.getDirection(), (int)this.tile.data.audioOffset), (Position)Minecraft.m_91087_().f_91074_.m_20318_(WaterFrames.deltaFrames()));
        if (min > max) {
            int temp = max;
            max = min;
            min = temp;
        }
        if (distance > (double)min) {
            int n = volume = distance > (double)(max + 1) ? 0 : (int)((double)volume * (1.0 - (distance - (double)min) / (double)(1 + max - min)));
        }
        if (WFConfig.useMasterVolume()) {
            volume = (int)((float)volume * Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER));
        }
        return volume;
    }

    public static enum Mode {
        VIDEO,
        PICTURE,
        AUDIO;

    }
}

