/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.watercollector.block.custom;

import com.leclowndu93150.watercollector.entity.ModBlockEntities;
import com.leclowndu93150.watercollector.entity.WatercollectorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WatercollectorRenderer
implements BlockEntityRenderer<WatercollectorBlockEntity> {
    public WatercollectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.WATERCOLLECTOR_ENTITY.get()), WatercollectorRenderer::new);
    }

    public void render(@NotNull WatercollectorBlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        FluidStack fluidStack = pBlockEntity.getFluidHandler().getFluidInTank(0);
        if (!fluidStack.isEmpty()) {
            int amount = fluidStack.getAmount();
            int total = pBlockEntity.getFluidHandler().getTankCapacity(0);
            this.renderFluidInTank((BlockAndTintGetter)pBlockEntity.m_58904_(), pBlockEntity.m_58899_(), fluidStack, pPoseStack, pBufferSource, (float)amount / (float)total);
        }
    }

    private void renderFluidInTank(BlockAndTintGetter world, BlockPos pos, FluidStack fluidStack, PoseStack matrix, MultiBufferSource buffer, float percent) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.29, 0.5);
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        Matrix3f matrix3f = matrix.m_85850_().m_252943_();
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        this.renderTopFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_85849_();
    }

    private void renderTopFluidFace(TextureAtlasSprite sprite, Matrix4f matrix4f, Matrix3f normalMatrix, VertexConsumer builder, int color, float percent) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float width = 0.75f;
        float height = 0.4375f;
        float minU = sprite.m_118367_(3.0);
        float maxU = sprite.m_118367_(13.0);
        float minV = sprite.m_118393_(3.0);
        float maxV = sprite.m_118393_(13.0);
        float pY = -height / 2.0f + percent * height;
        builder.m_252986_(matrix4f, -width / 2.0f, pY, -width / 2.0f).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -width / 2.0f, pY, width / 2.0f).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, width / 2.0f, pY, width / 2.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, width / 2.0f, pY, -width / 2.0f).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

