/*
 * Decompiled with CFR 0.152.
 */
package com.jmoiron.ulvcovm.data.covers;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidTransferDelegate;
import com.gregtechceu.gtceu.common.cover.data.BucketMode;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.utils.FluidStackHashStrategy;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PumpCoverExt
extends CoverBehavior
implements IUICover,
IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PumpCoverExt.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    protected static final long MILLIBUCKET_SIZE = FluidHelper.getBucket() / 1000L;
    public final int tier;
    public final long maxMilliBucketsPerTick;
    @Persisted
    @DescSynced
    protected long currentMilliBucketsPerTick;
    @Persisted
    @DescSynced
    @RequireRerender
    protected IO io = IO.OUT;
    @Persisted
    @DescSynced
    protected BucketMode bucketMode = BucketMode.MILLI_BUCKET;
    @Persisted
    @DescSynced
    protected ManualIOMode manualIOMode = ManualIOMode.DISABLED;
    @Persisted
    protected boolean isWorkingEnabled = true;
    protected long milliBucketsLeftToTransferLastSecond;
    @Persisted
    @DescSynced
    protected final FilterHandler<FluidStack, FluidFilter> filterHandler;
    protected final ConditionalSubscriptionHandler subscriptionHandler;
    private NumberInputWidget<Long> transferRateWidget;
    private CoverableFluidTransferWrapper fluidTransferWrapper;

    public PumpCoverExt(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        super(definition, coverHolder, attachedSide);
        this.tier = tier;
        this.currentMilliBucketsPerTick = this.maxMilliBucketsPerTick = Math.max(32L, 64L * (long)Math.pow(4.0, Math.min(tier - 1, 5)));
        this.milliBucketsLeftToTransferLastSecond = this.currentMilliBucketsPerTick * 20L;
        this.subscriptionHandler = new ConditionalSubscriptionHandler((ITickSubscription)coverHolder, this::update, this::isSubscriptionActive);
        this.filterHandler = FilterHandlers.fluid((IEnhancedManaged)this).onFilterLoaded(f -> this.configureFilter()).onFilterUpdated(f -> this.configureFilter()).onFilterRemoved(f -> this.configureFilter());
    }

    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled() && this.getAdjacentFluidTransfer() != null;
    }

    @Nullable
    protected IFluidTransfer getOwnFluidTransfer() {
        return FluidTransferHelper.getFluidTransfer((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide);
    }

    @Nullable
    protected IFluidTransfer getAdjacentFluidTransfer() {
        return FluidTransferHelper.getFluidTransfer((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos().m_121945_(this.attachedSide), (Direction)this.attachedSide.m_122424_());
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean canAttach() {
        return this.getOwnFluidTransfer() != null;
    }

    public void setIo(IO io) {
        if (io == IO.IN || io == IO.OUT) {
            this.io = io;
        }
    }

    public void onLoad() {
        super.onLoad();
        this.subscriptionHandler.initialize(this.coverHolder.getLevel());
    }

    public void onRemoved() {
        super.onRemoved();
        this.subscriptionHandler.unsubscribe();
    }

    public List<ItemStack> getAdditionalDrops() {
        List list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().m_41619_()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.subscriptionHandler.updateSubscription();
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.subscriptionHandler.updateSubscription();
        }
    }

    public void setTransferRate(long milliBucketsPerTick) {
        this.currentMilliBucketsPerTick = Math.min(Math.max(milliBucketsPerTick, 0L), this.maxMilliBucketsPerTick);
    }

    public void setBucketMode(BucketMode bucketMode) {
        long oldMultiplier = this.bucketMode.multiplier;
        long newMultiplier = bucketMode.multiplier;
        this.bucketMode = bucketMode;
        if (this.transferRateWidget == null) {
            return;
        }
        if (oldMultiplier > newMultiplier) {
            this.transferRateWidget.setValue((Number)this.getCurrentBucketModeTransferRate());
        }
        this.transferRateWidget.setMax((Number)(this.maxMilliBucketsPerTick / bucketMode.multiplier));
        if (newMultiplier > oldMultiplier) {
            this.transferRateWidget.setValue((Number)this.getCurrentBucketModeTransferRate());
        }
    }

    protected void setManualIOMode(ManualIOMode manualIOMode) {
        this.manualIOMode = manualIOMode;
        this.coverHolder.markDirty();
    }

    protected void update() {
        long timer = this.coverHolder.getOffsetTimer();
        if (timer % 5L != 0L) {
            return;
        }
        if (this.milliBucketsLeftToTransferLastSecond > 0L) {
            long platformTransferredFluid = this.doTransferFluids(this.milliBucketsLeftToTransferLastSecond * MILLIBUCKET_SIZE);
            this.milliBucketsLeftToTransferLastSecond -= platformTransferredFluid / MILLIBUCKET_SIZE;
        }
        if (timer % 20L == 0L) {
            this.milliBucketsLeftToTransferLastSecond = this.currentMilliBucketsPerTick * 20L;
        }
        this.subscriptionHandler.updateSubscription();
    }

    private long doTransferFluids(long platformTransferLimit) {
        IFluidTransfer adjacentFluidTransfer = this.getAdjacentFluidTransfer();
        IFluidTransfer ownFluidTransfer = this.getOwnFluidTransfer();
        if (adjacentFluidTransfer != null && ownFluidTransfer != null) {
            return switch (this.io) {
                case IO.IN -> this.doTransferFluidsInternal(adjacentFluidTransfer, ownFluidTransfer, platformTransferLimit);
                case IO.OUT -> this.doTransferFluidsInternal(ownFluidTransfer, adjacentFluidTransfer, platformTransferLimit);
                default -> 0L;
            };
        }
        return 0L;
    }

    protected long doTransferFluidsInternal(IFluidTransfer source, IFluidTransfer destination, long platformTransferLimit) {
        return this.transferAny(source, destination, platformTransferLimit);
    }

    protected long transferAny(IFluidTransfer source, IFluidTransfer destination, long platformTransferLimit) {
        return FluidTransferHelper.transferFluids((IFluidTransfer)source, (IFluidTransfer)destination, (long)platformTransferLimit, (Predicate)this.filterHandler.getFilter());
    }

    protected Map<FluidStack, Long> enumerateDistinctFluids(IFluidTransfer fluidTransfer, TransferDirection direction) {
        Object2LongOpenCustomHashMap summedFluids = new Object2LongOpenCustomHashMap((Hash.Strategy)FluidStackHashStrategy.comparingAllButAmount());
        for (int tank = 0; tank < fluidTransfer.getTanks(); ++tank) {
            FluidStack fluidStack;
            if (!PumpCoverExt.canTransfer(fluidTransfer, direction, tank) || (fluidStack = fluidTransfer.getFluidInTank(tank)).isEmpty()) continue;
            summedFluids.putIfAbsent(fluidStack, 0L);
            summedFluids.computeIfPresent(fluidStack, (stack, totalAmount) -> totalAmount + stack.getAmount());
        }
        return summedFluids;
    }

    private static boolean canTransfer(IFluidTransfer fluidTransfer, TransferDirection direction, int tank) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TransferDirection.INSERT -> fluidTransfer.supportsFill(tank);
            case TransferDirection.EXTRACT -> fluidTransfer.supportsDrain(tank);
        };
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 137);
        group.addWidget((Widget)new LabelWidget(10, 5, LocalizationUtils.format((String)this.getUITitle(), (Object[])new Object[]{GTValues.VN[this.tier]})));
        this.transferRateWidget = new LongInputWidget(10, 20, 134, 20, this::getCurrentBucketModeTransferRate, this::setCurrentBucketModeTransferRate).setMin((Number)0L);
        this.setBucketMode(this.bucketMode);
        group.addWidget(this.transferRateWidget);
        group.addWidget((Widget)new EnumSelectorWidget(146, 20, 20, 20, Arrays.stream(BucketMode.values()).filter(m -> m.multiplier <= this.maxMilliBucketsPerTick).toList(), (Enum)this.bucketMode, this::setBucketMode).setTooltipSupplier(this::getBucketModeTooltip));
        group.addWidget((Widget)new EnumSelectorWidget(10, 45, 20, 20, List.of(IO.IN, IO.OUT), (Enum)this.io, this::setIo));
        group.addWidget(new EnumSelectorWidget(146, 107, 20, 20, (Enum[])ManualIOMode.VALUES, (Enum)this.manualIOMode, this::setManualIOMode).setHoverTooltips(new String[]{"cover.universal.manual_import_export.mode.description"}));
        group.addWidget(this.filterHandler.createFilterSlotUI(125, 108));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 72, 156, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    private List<Component> getBucketModeTooltip(BucketMode mode, String langKey) {
        return List.of(Component.m_237115_((String)langKey).m_7220_((Component)Component.m_237115_((String)"gtceu.gui.content.units.per_tick")));
    }

    private long getCurrentBucketModeTransferRate() {
        return this.currentMilliBucketsPerTick / this.bucketMode.multiplier;
    }

    private void setCurrentBucketModeTransferRate(long transferRate) {
        this.setTransferRate(transferRate * this.bucketMode.multiplier);
    }

    @NotNull
    protected String getUITitle() {
        return "cover.pump.title";
    }

    protected void buildAdditionalUI(WidgetGroup group) {
    }

    protected void configureFilter() {
    }

    @Nullable
    public IFluidTransfer getFluidTransferCap(@Nullable IFluidTransfer defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (this.fluidTransferWrapper == null || this.fluidTransferWrapper.delegate != defaultValue) {
            this.fluidTransferWrapper = new CoverableFluidTransferWrapper(defaultValue);
        }
        return this.fluidTransferWrapper;
    }

    public long getCurrentMilliBucketsPerTick() {
        return this.currentMilliBucketsPerTick;
    }

    public IO getIo() {
        return this.io;
    }

    public BucketMode getBucketMode() {
        return this.bucketMode;
    }

    public ManualIOMode getManualIOMode() {
        return this.manualIOMode;
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    protected static enum TransferDirection {
        INSERT,
        EXTRACT;

    }

    private class CoverableFluidTransferWrapper
    extends FluidTransferDelegate {
        public CoverableFluidTransferWrapper(IFluidTransfer delegate) {
            super(delegate);
        }

        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            if (PumpCoverExt.this.io == IO.OUT && PumpCoverExt.this.manualIOMode == ManualIOMode.DISABLED) {
                return 0L;
            }
            if (!PumpCoverExt.this.filterHandler.test((Object)resource) && PumpCoverExt.this.manualIOMode == ManualIOMode.FILTERED) {
                return 0L;
            }
            return super.fill(tank, resource, simulate, notifyChanges);
        }

        public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            if (PumpCoverExt.this.io == IO.IN && PumpCoverExt.this.manualIOMode == ManualIOMode.DISABLED) {
                return FluidStack.empty();
            }
            if (PumpCoverExt.this.manualIOMode == ManualIOMode.FILTERED && !PumpCoverExt.this.filterHandler.test((Object)resource)) {
                return FluidStack.empty();
            }
            return super.drain(tank, resource, simulate, notifyChanges);
        }
    }
}

