/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public record ColorInfo(int base, int accent) {
    public static final ColorInfo NONE = new ColorInfo(0xFFFFFF, 0xFFFFFF);

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeInt(this.base);
        buffer.writeInt(this.accent);
    }

    public static ColorInfo fromNetwork(FriendlyByteBuf buffer) {
        return new ColorInfo(buffer.readInt(), buffer.readInt());
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.base() != 0xFFFFFF) {
            result.add("base", ColorInfo.serializeColor(this.base()));
        }
        if (this.accent() != this.base()) {
            result.add("accent", ColorInfo.serializeColor(this.accent()));
        }
        return result;
    }

    private static JsonElement serializeColor(int color) {
        return new JsonPrimitive(String.format("#%06X", color));
    }

    public static ColorInfo fromJson(JsonObject object) {
        int accent = 0xFFFFFF;
        int base = 0xFFFFFF;
        if (object.has("base")) {
            base = accent = ColorInfo.readColor(object.get("base"));
        }
        if (object.has("accent")) {
            accent = ColorInfo.readColor(object.get("accent"));
        }
        return new ColorInfo(base, accent);
    }

    private static int readColor(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            int red = GsonHelper.m_13927_((JsonObject)object, (String)"red");
            int green = GsonHelper.m_13927_((JsonObject)object, (String)"green");
            int blue = GsonHelper.m_13927_((JsonObject)object, (String)"blue");
            return red << 16 | green << 8 | blue;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return ColorInfo.parseColor(element.getAsString());
        }
        throw new JsonParseException(String.format("Expected color to be json object or string, got %s", element));
    }

    private static int parseColor(String string) {
        if (string.startsWith("#")) {
            return Integer.parseInt(string.substring(1), 16);
        }
        throw new JsonParseException(String.format("Couldn't parse color string: %s", string));
    }
}

