/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.common.block.entity.dynamo;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.common.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.dynamo.CompressionFuelManager;
import cofh.thermal.expansion.common.inventory.dynamo.DynamoCompressionMenu;
import cofh.thermal.expansion.init.registries.TExpBlockEntities;
import cofh.thermal.lib.common.block.entity.DynamoBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;

public class DynamoCompressionBlockEntity
extends DynamoBlockEntity {
    protected FluidStorageCoFH fuelTank = new FluidStorageCoFH(4000, fluid -> this.filter.valid(fluid) && CompressionFuelManager.instance().validFuel(fluid));

    public DynamoCompressionBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpBlockEntities.DYNAMO_COMPRESSION_TILE.get(), pos, state);
        this.tankInv.addTank(this.fuelTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return CompressionFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return CompressionFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) > 0 && this.fuelTank.getAmount() >= 100;
    }

    protected void processStart() {
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
        int fuelVal = Math.round((float)CompressionFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) * this.energyMod);
        this.processTick = Math.min(this.baseProcessTick, fuelVal);
        this.fuelMax = fuelVal;
        this.fuel += this.fuelMax;
        this.fuelTank.modify(-100);
    }

    protected boolean cacheRenderFluid() {
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.fuelTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DynamoCompressionMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }
}

