/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.Systeams;
import cofh.lib.common.fluid.FluidCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SteamFluid {
    public final RegistryObject<FluidType> type;
    public final Vector3f particleColor = new Vector3f(0.1f, 0.1f, 0.1f);
    public final RegistryObject<ForgeFlowingFluid> stillFluid;
    public final RegistryObject<ForgeFlowingFluid> flowingFluid;
    private static final BlockBehaviour.Properties fluidBlockProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_284268_(DyeColor.LIGHT_GRAY);
    private static final Item.Properties bucketItemProperties = new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1);
    protected final RegistryObject<Item> bucket;

    public SteamFluid(DeferredRegisterCoFH<Fluid> fluidRegister, DeferredRegisterCoFH<FluidType> typeRegister, DeferredRegisterCoFH<Block> blockRegister, DeferredRegisterCoFH<Item> itemRegister, String id) {
        this.stillFluid = fluidRegister.register(id, () -> new Source(this.fluidProperties()));
        this.flowingFluid = fluidRegister.register(FluidCoFH.flowing((String)id), () -> new Flowing(this.fluidProperties()));
        this.bucket = itemRegister.register(id + "_bucket", () -> new BucketItem(this.stillFluid, bucketItemProperties));
        this.type = typeRegister.register(id, () -> new FluidType(FluidType.Properties.create().canDrown(true).canExtinguish(true).canHydrate(true).density(-250).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation STILL = Systeams.MODRL.m_247449_("block/steam_still");
                    private static final ResourceLocation FLOW = Systeams.MODRL.m_247449_("block/steam_flow");

                    public ResourceLocation getStillTexture() {
                        return STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOW;
                    }

                    public ResourceLocation getOverlayTexture() {
                        return FluidCoFH.WATER_OVERLAY;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return FluidCoFH.UNDERWATER_LOCATION;
                    }

                    @NotNull
                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return SteamFluid.this.particleColor;
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        nearDistance = -16.0f;
                        farDistance = 16.0f;
                        if (farDistance > renderDistance) {
                            farDistance = renderDistance;
                            shape = FogShape.CYLINDER;
                        }
                        RenderSystem.setShaderFogStart((float)nearDistance);
                        RenderSystem.setShaderFogEnd((float)farDistance);
                        RenderSystem.setShaderFogShape((FogShape)shape);
                    }
                });
            }
        });
    }

    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type(), this.stillFluid, this.flowingFluid).bucket(this.bucket).tickRate(2).slopeFindDistance(1);
    }

    protected Supplier<FluidType> type() {
        return this.type;
    }

    public Fluid getStill() {
        return (Fluid)this.stillFluid.get();
    }

    public Fluid getFlowing() {
        return (Fluid)this.flowingFluid.get();
    }

    public class Flowing
    extends SteamFlowingFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }

    public class Source
    extends SteamFlowingFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean m_7444_(FluidState pState) {
            return true;
        }

        public int m_7430_(FluidState pState) {
            return 8;
        }
    }

    public abstract class SteamFlowingFluid
    extends ForgeFlowingFluid {
        public static boolean warnOnFlow = true;

        public SteamFlowingFluid(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        protected boolean m_75956_(BlockGetter pLevel, Fluid pFluid, BlockPos p_75959_, BlockState p_75960_, BlockPos p_75961_, BlockState p_75962_) {
            if (!this.m_76061_(Direction.UP, pLevel, p_75959_, p_75960_, p_75961_, p_75962_)) {
                return false;
            }
            return p_75962_.m_60819_().m_76152_().m_6212_((Fluid)this) || this.m_75972_(pLevel, p_75961_, p_75962_, pFluid);
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            entity.m_19920_(entity.m_20142_() ? 0.7f : 0.5f, movementVector);
            entity.m_6478_(MoverType.SELF, entity.m_20184_());
            entity.m_20256_(entity.m_20184_().m_82542_(0.0, gravity * 10.0, 0.0));
            return true;
        }

        protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluidIn, Direction direction) {
            return direction == Direction.UP && !this.m_6212_(fluidIn);
        }

        public void m_6292_(Level level, BlockPos pos, FluidState currentFluidState) {
            BlockState currentBlockState = level.m_8055_(pos);
            if (this.m_7444_(currentFluidState)) {
                if (this.isTooColdForSteam(level)) {
                    level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.9f, level.m_213780_().m_188501_());
                    return;
                }
                Direction flowDir = Direction.UP;
                BlockPos flowToPos = pos.m_121945_(flowDir);
                boolean canFlowUp = this.m_75977_((BlockGetter)level, pos, currentBlockState, flowDir, flowToPos, level.m_8055_(flowToPos), level.m_6425_(flowToPos), (Fluid)SteamFluid.this.stillFluid.get());
                if (canFlowUp) {
                    int flags = 3;
                    if (level.m_6425_(flowToPos).m_76152_() != SteamFluid.this.flowingFluid.get()) {
                        flags |= 0x80;
                    }
                    level.m_7731_(flowToPos, currentFluidState.m_76188_(), flags);
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), flags);
                    if (pos.m_123342_() > 100 && warnOnFlow) {
                        Systeams.LGGR.warn("A steam block flowed above y 100! If you are experiencing major lag spikes, this is likely the cause (silly lighting updates)");
                        Systeams.LGGR.warn("Also.. how on earth did you place a steam fluid block?? These aren't even registered!");
                    }
                    return;
                }
                this.m_76014_(level, pos, currentFluidState, currentBlockState);
                return;
            }
            int maxSurroundingLevel = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                FluidState stateInDir = level.m_6425_(pos.m_121945_(dir));
                if (stateInDir.m_76152_() == SteamFluid.this.stillFluid.get()) {
                    maxSurroundingLevel = 8;
                    break;
                }
                if (stateInDir.m_76152_() != SteamFluid.this.flowingFluid.get()) continue;
                maxSurroundingLevel = Math.max(maxSurroundingLevel, (Integer)stateInDir.m_61143_((Property)f_75948_));
            }
            level.m_7731_(pos, (maxSurroundingLevel -= this.m_6713_((LevelReader)level)) > 0 ? this.m_75953_(maxSurroundingLevel, false).m_76188_() : Blocks.f_50016_.m_49966_(), 3);
            this.m_76014_(level, pos, currentFluidState, currentBlockState);
        }

        protected boolean m_75977_(BlockGetter level, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluid) {
            if (Direction.Plane.HORIZONTAL == direction.m_122434_().m_122480_() && level.m_8055_(toPos.m_7494_()).m_60795_()) {
                return false;
            }
            if (direction == Direction.UP && toFluidState.m_76152_() == SteamFluid.this.flowingFluid.get()) {
                return true;
            }
            return super.m_75977_(level, fromPos, fromBlockState, direction, toPos, toBlockState, toFluidState, fluid);
        }

        private boolean isTooColdForSteam(Level level) {
            return !level.m_6042_().f_63857_();
        }
    }
}

