/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.TemplatePersistanceControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.settings.StorageSettingsTabControlBase;

public abstract class SettingsScreen
extends AbstractContainerScreen<SettingsContainerMenu<?>>
implements InventoryScrollPanel.IInventoryScreen {
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private StorageSettingsTabControlBase settingsTabControl;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private TemplatePersistanceControl templatePersistanceControl = null;
    private StorageBackgroundProperties storageBackgroundProperties;
    private boolean mouseDragHandledByOther = false;

    protected SettingsScreen(SettingsContainerMenu<?> screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.updateDimensionsAndSlotPositions(Minecraft.m_91087_().m_91268_().m_85446_());
        this.settingsTabControl = this.initializeTabControl();
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.updateDimensionsAndSlotPositions(pHeight);
        super.m_6574_(pMinecraft, pWidth, pHeight);
    }

    private void updateDimensionsAndSlotPositions(int pHeight) {
        int displayableNumberOfRows = Math.min((pHeight - 114) / 18, ((SettingsContainerMenu)this.m_6262_()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((SettingsContainerMenu)this.m_6262_()).getNumberOfStorageInventorySlots() + ((SettingsContainerMenu)this.m_6262_()).getColumnsTaken() * ((SettingsContainerMenu)this.m_6262_()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.f_97726_ = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        if (displayableNumberOfRows < ((SettingsContainerMenu)this.m_6262_()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.f_97726_ += 6;
        }
        this.f_97727_ = newImageHeight;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.m_169411_((GuiEventListener)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((SettingsContainerMenu)this.m_6262_()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(Minecraft.m_91087_(), this, 0, ((SettingsContainerMenu)this.m_6262_()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, this.getGuiTop() + 17, this.getGuiLeft() + 7);
            this.m_142416_((GuiEventListener)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsYPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.f_97727_ - 114) / 18, ((SettingsContainerMenu)this.m_6262_()).getNumberOfRows());
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        int slotIndex = 0;
        while (slotIndex < ((SettingsContainerMenu)this.m_6262_()).getNumberOfStorageInventorySlots()) {
            Slot slot = ((SettingsContainerMenu)this.m_6262_()).m_38853_(slotIndex);
            int lineIndex = slotIndex % this.getSlotsOnLine();
            slot.f_40220_ = 8 + lineIndex * 18;
            slot.f_40221_ = yPosition;
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((SettingsContainerMenu)this.m_6262_()).getColumnsTaken();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateInventoryScrollPanel();
        this.settingsTabControl = this.initializeTabControl();
        this.templatePersistanceControl = this.initializeTemplatePersistanceControl();
        this.m_7787_(this.settingsTabControl);
        this.m_7787_(this.templatePersistanceControl);
    }

    private TemplatePersistanceControl initializeTemplatePersistanceControl() {
        return new TemplatePersistanceControl(new Position(this.f_97735_ + this.f_97730_ - 29, this.f_97736_ + this.f_97731_ + 29), ((SettingsContainerMenu)this.m_6262_()).getTemplatePersistanceContainer());
    }

    protected abstract StorageSettingsTabControlBase initializeTabControl();

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        StorageGuiHelper.renderStorageBackground(new Position(x, y), guiGraphics, this.storageBackgroundProperties.getTextureName(), this.f_97726_, this.getStorageInventoryHeight(this.getNumberOfVisibleRows()));
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(guiGraphics, x, y, ((SettingsContainerMenu)this.m_6262_()).getStorageInventorySlots().size());
        }
    }

    protected void drawSlotBg(GuiGraphics guiGraphics, int x, int y, int visibleSlotsCount) {
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = visibleSlotsCount / slotsOnLine;
        int remainingSlots = visibleSlotsCount % slotsOnLine;
        GuiHelper.renderSlotsBackground(guiGraphics, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ((SettingsContainerMenu)this.f_97732_).detectSettingsChangeAndReload();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, -20.0f);
        this.m_280273_(guiGraphics);
        poseStack.m_85849_();
        this.settingsTabControl.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.templatePersistanceControl.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((Screen)this, guiGraphics, mouseX, mouseY);
        this.templatePersistanceControl.renderTooltip((Screen)this, guiGraphics, mouseX, mouseY);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderInventorySlots(guiGraphics, mouseX, mouseY, true);
        }
    }

    @Override
    public void renderInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        for (int slotId = 0; slotId < ((SettingsContainerMenu)this.f_97732_).ghostSlots.size(); ++slotId) {
            Slot slot = ((SettingsContainerMenu)this.f_97732_).ghostSlots.get(slotId);
            this.m_280092_(guiGraphics, slot);
            this.settingsTabControl.renderSlotOverlays(guiGraphics, slot, this::renderSlotOverlay, this.isTemplateLoadHovered());
            if (canShowHover && this.m_97774_(slot, mouseX, mouseY) && slot.m_6659_()) {
                this.f_97734_ = slot;
                SettingsScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.f_40220_, (int)slot.f_40221_, (int)0, (int)this.getSlotColor(slotId));
            }
            this.settingsTabControl.renderSlotExtra(guiGraphics, slot);
        }
    }

    protected void m_280092_(GuiGraphics guiGraphics, Slot slot) {
        ItemStack itemstack = slot.m_7993_() != ItemStack.f_41583_ ? slot.m_7993_() : this.settingsTabControl.getSlotStackDisplayOverride(slot.getSlotIndex(), this.isTemplateLoadHovered());
        RenderSystem.enableDepthTest();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        if (!this.settingsTabControl.renderGuiItem(guiGraphics, this.f_96541_.m_91291_(), itemstack, slot, this.isTemplateLoadHovered())) {
            if (!((SettingsContainerMenu)this.m_6262_()).getSlotFilterItem(slot.f_40219_).m_41619_()) {
                guiGraphics.m_280480_(((SettingsContainerMenu)this.m_6262_()).getSlotFilterItem(slot.f_40219_), slot.f_40220_, slot.f_40221_);
            } else {
                Pair pair = slot.m_7543_();
                if (pair != null) {
                    TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                    guiGraphics.m_280159_(slot.f_40220_, slot.f_40221_, 0, 16, 16, textureatlassprite);
                }
            }
        }
        poseStack.m_85849_();
        this.settingsTabControl.drawSlotStackOverlay(guiGraphics, slot, this.isTemplateLoadHovered());
    }

    private boolean isTemplateLoadHovered() {
        return this.templatePersistanceControl.isTemplateLoadHovered();
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, mouseButton);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.mouseDragHandledByOther) {
            return false;
        }
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (slot != null) {
            this.settingsTabControl.handleSlotClick(slot, button);
        }
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Nullable
    protected Slot m_97744_(double mouseX, double mouseY) {
        for (int i = 0; i < ((SettingsContainerMenu)this.f_97732_).ghostSlots.size(); ++i) {
            Slot slot = ((SettingsContainerMenu)this.f_97732_).ghostSlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.m_110087_((int)mouseX, (int)mouseY));
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor) {
        this.renderSlotOverlay(guiGraphics, slot.f_40220_, slot.f_40221_, 16, slotColor);
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, int xPos, int yPos, int height, int slotColor) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.m_280024_(xPos, yPos, xPos + 16, yPos + height, slotColor, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.sendStorageInventoryScreenOpenMessage();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected abstract void sendStorageInventoryScreenOpenMessage();

    public StorageSettingsTabControlBase getSettingsTabControl() {
        return this.settingsTabControl;
    }

    @Override
    public boolean isMouseOverSlot(Slot pSlot, double pMouseX, double pMouseY) {
        return this.m_97774_(pSlot, pMouseX, pMouseY);
    }

    @Override
    public void drawSlotBg(GuiGraphics guiGraphics, int visibleSlotsCount) {
        this.drawSlotBg(guiGraphics, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2, visibleSlotsCount);
    }

    @Override
    public int getTopY() {
        return this.getGuiTop();
    }

    @Override
    public int getLeftX() {
        return this.getGuiLeft();
    }

    @Override
    public Slot getSlot(int slotIndex) {
        return ((SettingsContainerMenu)this.m_6262_()).m_38853_(slotIndex);
    }

    public void startMouseDragHandledByOther() {
        this.mouseDragHandledByOther = true;
    }

    public void stopMouseDragHandledByOther() {
        this.mouseDragHandledByOther = false;
    }
}

