/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.entities.hook;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.oe.rehooked.data.ChainRegistry;
import com.oe.rehooked.data.HookData;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.entities.hook.HookEntityModel;
import com.oe.rehooked.entities.layers.ReHookedModelLayers;
import com.oe.rehooked.utils.PositionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HookEntityRenderer
extends EntityRenderer<HookEntity> {
    protected EntityModel<HookEntity> model;
    protected EntityRendererProvider.Context pContext;
    protected float lastDelta;

    public HookEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new HookEntityModel(pContext.m_174023_(ReHookedModelLayers.HOOK_PROJECTILE_LAYER));
        this.pContext = pContext;
        this.lastDelta = 0.0f;
    }

    public boolean shouldRender(HookEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (pLivingEntity.m_213877_() || pLivingEntity.getHookType().isEmpty() || pLivingEntity.getState().equals((Object)HookEntity.State.DONE)) {
            return false;
        }
        if (pLivingEntity.tryGetOwnerFromCachedId() != null) {
            Player owner = pLivingEntity.tryGetOwnerFromCachedId();
            if (Minecraft.m_91087_().f_91074_ != null && owner.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                return true;
            }
            return pCamera.m_113029_(owner.m_20191_()) || super.m_5523_((Entity)pLivingEntity, pCamera, pCamX, pCamY, pCamZ);
        }
        return false;
    }

    public void render(HookEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.handleHook(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, 0xF000F0);
        if (pEntity.hasChain() && pEntity.tryGetOwnerFromCachedId() != null) {
            this.handleChain(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        }
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, 0xF000F0);
    }

    private void handleHook(HookEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        Vec3 direction = new Vec3(pEntity.getShotDirection());
        Vec3 lookAt = pEntity.m_146892_().m_82549_(direction);
        pEntity.m_7618_(EntityAnchorArgument.Anchor.EYES, lookAt);
        AABB box = pEntity.m_20191_();
        pPoseStack.m_85841_((float)box.m_82362_(), (float)box.m_82376_(), (float)box.m_82385_());
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(pEntity.m_146908_() + 270.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(pEntity.m_146909_() + 90.0f));
        pPoseStack.m_252880_(0.0f, -1.0f, 0.0f);
        this.model.m_7695_(pPoseStack, pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity))), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
    }

    private void handleChain(HookEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        Player owner = pEntity.tryGetOwnerFromCachedId();
        Vec3 waistPos = PositionHelper.getWaistPosition((Entity)owner);
        Vec3 hookPos = pEntity.m_20182_();
        Vec3 playerToHook = waistPos.m_82505_(hookPos);
        Vec3 normal = playerToHook.m_82541_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252961_(1.5707964f - (float)Mth.m_14136_((double)normal.f_82481_, (double)normal.f_82479_)));
        pPoseStack.m_252781_(Axis.f_252529_.m_252961_((float)Math.acos(normal.f_82480_) - (float)Math.PI));
        pPoseStack.m_85837_(-0.5, 0.0, -0.5);
        float distance = (float)playerToHook.m_82553_();
        BlockState chain = ChainRegistry.getChain(pEntity.getHookType()).m_49966_();
        for (int i = 0; i < (int)distance; ++i) {
            this.pContext.m_234597_().m_110912_(chain, pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
            pPoseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        float delta = distance - (float)((int)distance);
        if (this.lastDelta == 0.0f) {
            this.lastDelta = delta;
        }
        if (Math.abs(delta - this.lastDelta) < 0.3f) {
            delta = this.lastDelta;
        }
        pPoseStack.m_85841_(1.0f, delta, 1.0f);
        this.lastDelta = delta;
        this.pContext.m_234597_().m_110912_(chain, pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(HookEntity pEntity) {
        return pEntity.getHookData().map(HookData::texture).orElseGet(null);
    }
}

