/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.utils;

import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VectorHelper {
    public static BlockHitResult getFromEntityAndAngle(Entity entity, Vec3 angle, double range) {
        return VectorHelper.getFromEntityAndAngle(entity, angle, ClipContext.Fluid.NONE, range, Entity::m_20182_);
    }

    public static BlockHitResult getFromEntityAndAngle(Entity entity, Vec3 angle, double range, Function<Entity, Vec3> startPositionGetter) {
        return VectorHelper.getFromEntityAndAngle(entity, angle, ClipContext.Fluid.NONE, range, startPositionGetter);
    }

    public static BlockHitResult getFromEntityAndAngle(Entity entity, Vec3 angle, ClipContext.Fluid rayTraceFluid, double range, Function<Entity, Vec3> startPositionGetter) {
        Level world = entity.m_9236_();
        Vec3 end = entity.m_146892_().m_82549_(angle.m_82490_(range));
        ClipContext context = new ClipContext(startPositionGetter.apply(entity), end, ClipContext.Block.COLLIDER, rayTraceFluid, entity);
        return world.m_45547_(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends Entity> Optional<T> acquireLookTarget(Class<T> clazz, Player seeker, double radius) {
        Vec3 lookAngle = seeker.m_20154_();
        double targetX = seeker.m_20185_();
        double targetY = seeker.m_20188_();
        double targetZ = seeker.m_20189_();
        double distanceTraveled = 0.0;
        Optional optHandler = IClientPlayerHookHandler.FromPlayer(seeker).resolve();
        if (optHandler.isPresent()) {
            IClientPlayerHookHandler handler = (IClientPlayerHookHandler)optHandler.get();
            double range = handler.getMaxHookDistance();
            while ((double)((int)distanceTraveled) < range) {
                distanceTraveled += 1.0;
                AABB bb = new AABB((targetX += lookAngle.f_82479_) - radius, (targetY += lookAngle.f_82480_) - radius, (targetZ += lookAngle.f_82481_) - radius, targetX + radius, targetY + radius, targetZ + radius);
                List list = seeker.m_9236_().m_45976_(clazz, bb);
                for (Entity target : list) {
                    if (target == seeker) continue;
                    return Optional.of(target);
                }
            }
        }
        return Optional.empty();
    }

    public static class Box {
        public double lX = Double.POSITIVE_INFINITY;
        public double lY;
        public double lZ;
        public double hX = Double.NEGATIVE_INFINITY;
        public double hY;
        public double hZ;

        public Box() {
            this.lY = Double.POSITIVE_INFINITY;
            this.hY = Double.NEGATIVE_INFINITY;
            this.lZ = Double.POSITIVE_INFINITY;
            this.hZ = Double.NEGATIVE_INFINITY;
        }

        public void reassignPoints(Vec3 ... points) {
            for (Vec3 point : points) {
                if (this.lX > point.f_82479_) {
                    this.lX = point.f_82479_;
                }
                if (this.hX < point.f_82479_) {
                    this.hX = point.f_82479_;
                }
                if (this.lY > point.f_82480_) {
                    this.lY = point.f_82480_;
                }
                if (this.hY < point.f_82480_) {
                    this.hY = point.f_82480_;
                }
                if (this.lZ > point.f_82481_) {
                    this.lZ = point.f_82481_;
                }
                if (!(this.hZ < point.f_82481_)) continue;
                this.hZ = point.f_82481_;
            }
        }

        public boolean isInside(Vec3 pos) {
            if (pos.f_82479_ < this.lX || pos.f_82479_ > this.hX) {
                return false;
            }
            if (pos.f_82480_ < this.lY || pos.f_82480_ > this.hY) {
                return false;
            }
            return !(pos.f_82481_ < this.lZ) && !(pos.f_82481_ > this.hZ);
        }

        public Vec3 closestPointInCube(Vec3 pos) {
            double x = Mth.m_14008_((double)pos.f_82479_, (double)this.lX, (double)this.hX);
            double y = Mth.m_14008_((double)pos.f_82480_, (double)this.lY, (double)this.hY);
            double z = Mth.m_14008_((double)pos.f_82481_, (double)this.lZ, (double)this.hZ);
            return new Vec3(x, y, z);
        }

        public String toString() {
            return "low: (" + this.lX + ", " + this.lY + ", " + this.lZ + "), high: (" + this.hX + ", " + this.hY + ", " + this.hZ + ")";
        }
    }
}

