/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.item;

import com.oe.rehooked.data.HookData;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.item.hook.HookItem;
import com.oe.rehooked.particle.ReHookedParticles;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ReHookedItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"rehooked");
    public static final RegistryObject<Item> WOOD_HOOK = ITEMS.register("wood_hook", () -> new HookItem("wood"));
    public static final RegistryObject<Item> IRON_HOOK = ITEMS.register("iron_hook", () -> new HookItem("iron"));
    public static final RegistryObject<Item> DIAMOND_HOOK = ITEMS.register("diamond_hook", () -> new HookItem("diamond"));
    public static final RegistryObject<Item> RED_HOOK = ITEMS.register("red_hook", () -> new HookItem("red"));
    public static final RegistryObject<Item> ENDER_HOOK = ITEMS.register("ender_hook", () -> new HookItem("ender"));

    public static void register(IEventBus eventBus) {
        HookRegistry.registerHook("wood", new HookData(1, 16.0f, 12.0f, 6.0f, false, ReHookedItems.getHookTexture("wood"), () -> null));
        HookRegistry.registerHook("iron", new HookData(2, 32.0f, 24.0f, 12.0f, false, ReHookedItems.getHookTexture("iron"), () -> null));
        HookRegistry.registerHook("diamond", new HookData(4, 64.0f, 48.0f, 24.0f, false, ReHookedItems.getHookTexture("diamond"), () -> null));
        HookRegistry.registerHook("ender", new HookData(1, 96.0f, Float.MAX_VALUE, 48.0f, false, ReHookedItems.getHookTexture("ender"), () -> null));
        HookRegistry.registerHook("red", new HookData(3, 16.0f, 8.0f, 6.0f, true, ReHookedItems.getHookTexture("red"), () -> ReHookedParticles.RED_HOOK_PARTICLE.get()));
        ITEMS.register(eventBus);
    }

    private static ResourceLocation getHookTexture(String name) {
        return new ResourceLocation("rehooked", "textures/entity/hook/" + name + "/" + name + ".png");
    }
}

