/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.events.subscribers.common;

import com.mojang.logging.LogUtils;
import com.oe.rehooked.capabilities.hooks.ClientHookCapabilityProvider;
import com.oe.rehooked.capabilities.hooks.ServerHookCapabilityProvider;
import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="rehooked", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventBus {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (player.m_9236_().m_5776_()) {
                if (!IClientPlayerHookHandler.FromPlayer(player).isPresent()) {
                    event.addCapability(new ResourceLocation("rehooked", "capabilities.hook.client"), (ICapabilityProvider)new ClientHookCapabilityProvider());
                }
            } else if (!player.m_9236_().m_5776_() && !IServerPlayerHookHandler.FromPlayer(player).isPresent()) {
                event.addCapability(new ResourceLocation("rehooked", "capabilities.hook.server"), (ICapabilityProvider)new ServerHookCapabilityProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        IServerPlayerHookHandler.FromPlayer(event.getEntity()).ifPresent(ICommonPlayerHookHandler::removeAllHooks);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        event.getServer().m_6846_().m_11314_().forEach(player -> IServerPlayerHookHandler.FromPlayer((Player)player).ifPresent(handler -> {
            handler.setOwner((Player)player).update();
            if (handler.shouldMoveThisTick()) {
                player.m_20256_(handler.getDeltaVThisTick());
            }
        }));
    }
}

