/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.redstoneclock.client.screen;

import com.hexagram2021.redstoneclock.client.screen.IButton;
import com.hexagram2021.redstoneclock.common.menu.RedstoneClockMenu;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RedstoneClockScreen
extends AbstractContainerScreen<RedstoneClockMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("redstoneclock", "textures/gui/redstone_clock.png");
    private static final Component TEXT_SIGNAL_STRENGTH = Component.m_237115_((String)"screen.redstoneclock.redstone_clock.signal_strength");
    private static final Component TEXT_ACTIVE_INTERVAL = Component.m_237115_((String)"screen.redstoneclock.redstone_clock.active_interval");
    private static final Component TEXT_IDLE_INTERVAL = Component.m_237115_((String)"screen.redstoneclock.redstone_clock.idle_interval");
    private static final RCButton[] BUTTONS = new RCButton[]{new RCButton(7, 24, 16, 16, 0, 136, 0), new RCButton(27, 24, 16, 16, 16, 136, 1), new RCButton(7, 56, 16, 16, 0, 136, 2), new RCButton(27, 56, 16, 16, 16, 136, 3), new RCButton(7, 88, 16, 16, 0, 136, 4), new RCButton(27, 88, 16, 16, 16, 136, 5), new RCButton(116, 112, 40, 16, 32, 136, 6){

        @Override
        public boolean release(RedstoneClockMenu menu, MultiPlayerGameMode gameMode, int leftPos, int topPos, double x, double y) {
            boolean ret = super.release(menu, gameMode, leftPos, topPos, x, y);
            if (ret) {
                menu.setNextMultiplier();
            }
            return ret;
        }
    }};

    public RedstoneClockScreen(RedstoneClockMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 216;
        this.f_97727_ = 136;
    }

    public void m_88315_(GuiGraphics transform, int x, int y, float partialTicks) {
        super.m_88315_(transform, x, y, partialTicks);
        this.m_280072_(transform, x, y);
    }

    protected void m_280003_(GuiGraphics transform, int x, int y) {
        transform.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        transform.m_280614_(this.f_96547_, TEXT_SIGNAL_STRENGTH, 50, 28, 0x404040, false);
        transform.m_280614_(this.f_96547_, TEXT_ACTIVE_INTERVAL, 50, 60, 0x404040, false);
        transform.m_280614_(this.f_96547_, TEXT_IDLE_INTERVAL, 50, 92, 0x404040, false);
        transform.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.valueOf(((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(0))), 168, 28, 0xFFFFFF, false);
        int activeInterval = ((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(1);
        transform.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)(activeInterval >= 10000 ? activeInterval / 1000 + "." + activeInterval / 100 % 10 + "k" : String.valueOf(activeInterval))), 168, 60, 0xFFFFFF, false);
        int idleInterval = ((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(2);
        transform.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)(idleInterval >= 10000 ? idleInterval / 1000 + "." + idleInterval / 100 % 10 + "k" : String.valueOf(idleInterval))), 168, 92, 0xFFFFFF, false);
        String multi = "*" + RedstoneClockMenu.toMultiplier(((RedstoneClockMenu)this.f_97732_).getMultiplier());
        transform.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)multi), 152 - this.f_96547_.m_92895_(multi), 117, 0x404040, false);
        MutableComponent multiText = Component.m_237115_((String)"screen.redstoneclock.redstone_clock.multiplier");
        transform.m_280614_(this.f_96547_, (Component)multiText, 114 - this.f_96547_.m_92852_((FormattedText)multiText), 116, 0xA0A0A0, false);
    }

    protected void m_7286_(GuiGraphics transform, float ticks, int x, int y) {
        this.m_280273_(transform);
        transform.m_280218_(BG_LOCATION, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderButtons(transform, x, y);
        this.renderSignals(transform);
    }

    private void renderButtons(GuiGraphics transform, int x, int y) {
        for (RCButton b : BUTTONS) {
            b.render(transform, this.f_97735_, this.f_97736_, x, y);
        }
    }

    private void renderSignals(GuiGraphics transform) {
        int cyclicTick = ((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(3);
        if (cyclicTick < 0) {
            return;
        }
        transform.m_280218_(BG_LOCATION, this.f_97735_ + 160, this.f_97736_ + 6, 216, 0, 10, 10);
        int activeInterval = ((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(1);
        if (cyclicTick < activeInterval) {
            transform.m_280218_(BG_LOCATION, this.f_97735_ + 176, this.f_97736_ + 6, 216, 0, 10, 10);
        }
    }

    protected void m_280072_(GuiGraphics transform, int x, int y) {
        super.m_280072_(transform, x, y);
        int logicX = x - this.f_97735_;
        int logicY = y - this.f_97736_;
        if (logicX >= 166 && logicX < 206) {
            int interval;
            if (logicY >= 57 && logicY < 71) {
                interval = ((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(1);
            } else if (logicY >= 89 && logicY < 103) {
                interval = ((RedstoneClockMenu)this.f_97732_).redstoneClock.m_6413_(2);
            } else {
                return;
            }
            int ms = interval % 20 * 50;
            int s = interval / 20;
            int m = s / 60;
            int h = m / 60;
            transform.m_280677_(this.f_96547_, List.of(Component.m_237110_((String)"screen.redstoneclock.redstone_clock.tooltip.total_ticks", (Object[])new Object[]{interval}), Component.m_237110_((String)"screen.redstoneclock.redstone_clock.tooltip.time", (Object[])new Object[]{h, m %= 60, s %= 60, ms})), Optional.empty(), x, y);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91072_);
        for (RCButton b : BUTTONS) {
            if (!b.click((RedstoneClockMenu)this.f_97732_, gameMode, this.f_97735_, this.f_97736_, x, y)) continue;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91072_);
        for (RCButton b : BUTTONS) {
            if (!b.release((RedstoneClockMenu)this.f_97732_, gameMode, this.f_97735_, this.f_97736_, x, y)) continue;
            return true;
        }
        return super.m_6348_(x, y, button);
    }

    static class RCButton
    implements IButton<RedstoneClockMenu> {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        private final int texX;
        private final int texY;
        private final int index;
        private boolean pressed;

        public RCButton(int posX, int posY, int width, int height, int texX, int texY, int index) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.texX = texX;
            this.texY = texY;
            this.index = index;
            this.pressed = false;
        }

        @Override
        public void render(GuiGraphics transform, int leftPos, int topPos, int x, int y) {
            int buttonTexYAddition = 0;
            int screenX = leftPos + this.posX;
            int screenY = topPos + this.posY;
            if (x >= screenX && x < screenX + this.width && y >= screenY && y < screenY + this.height) {
                buttonTexYAddition = this.pressed ? this.height : this.height * 2;
            }
            transform.m_280218_(BG_LOCATION, screenX, screenY, this.texX, this.texY + buttonTexYAddition, this.width, this.height);
        }

        @Override
        public boolean click(RedstoneClockMenu menu, MultiPlayerGameMode gameMode, int leftPos, int topPos, double x, double y) {
            int screenX = leftPos + this.posX;
            int screenY = topPos + this.posY;
            if (x >= (double)screenX && x < (double)(screenX + this.width) && y >= (double)screenY && y < (double)(screenY + this.height)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.pressed = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean release(RedstoneClockMenu menu, MultiPlayerGameMode gameMode, int leftPos, int topPos, double x, double y) {
            int screenX = leftPos + this.posX;
            int screenY = topPos + this.posY;
            if (x >= (double)screenX && x < (double)(screenX + this.width) && y >= (double)screenY && y < (double)(screenY + this.height) && this.pressed) {
                this.pressed = false;
                gameMode.m_105208_(menu.f_38840_, this.index);
                return true;
            }
            return false;
        }
    }
}

