/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static int size(@NotNull Iterable<?> data) {
        if (data instanceof Collection) {
            return ((Collection)data).size();
        }
        int counter = 0;
        for (Object ignored : data) {
            ++counter;
        }
        return counter;
    }

    public static <K, V> @Nullable Map<K, @NotNull V> newConcurrentHashMap(@Nullable Map<K, @NotNull V> map) {
        if (map != null) {
            return new ConcurrentHashMap<K, V>(map);
        }
        return null;
    }

    public static <K, V> @Nullable Map<K, @NotNull V> newHashMap(@Nullable Map<K, @NotNull V> map) {
        if (map != null) {
            return new HashMap<K, V>(map);
        }
        return null;
    }

    @Nullable
    public static <T> List<T> newArrayList(@Nullable List<T> list) {
        if (list != null) {
            return new ArrayList<T>(list);
        }
        return null;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapEntries(@NotNull Map<K, V> map, @NotNull Predicate<Map.Entry<K, V>> predicate) {
        HashMap<K, V> filteredMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry)) continue;
            filteredMap.put(entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

