/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EnchantedItemTrade
extends TransformableTrade<EnchantedItemTrade> {
    private final Item itemToEnchant;
    List<Enchantment> enchantments;
    private int minEnchantmentAmount = 1;
    private int maxEnchantmentAmount = 1;

    public EnchantedItemTrade(TradeItem[] inputs, Item itemToEnchant) {
        super(inputs);
        this.itemToEnchant = itemToEnchant;
        this.enchantments = BuiltInRegistries.f_256876_.m_123024_().toList();
    }

    public EnchantedItemTrade enchantments(Enchantment ... enchantments) {
        this.enchantments = Arrays.stream(enchantments).peek(e -> {
            if (e == null) {
                ConsoleJS.SERVER.error((Object)("Null enchantment in array: " + Arrays.toString(enchantments)));
            }
        }).filter(Objects::nonNull).toList();
        return this;
    }

    public EnchantedItemTrade amount(int min, int max) {
        this.minEnchantmentAmount = min;
        this.maxEnchantmentAmount = max;
        return this;
    }

    public EnchantedItemTrade amount(int amount) {
        return this.amount(amount, amount);
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity entity, RandomSource random) {
        ItemStack result = this.itemToEnchant.equals(Items.f_42517_) ? new ItemStack((ItemLike)Items.f_42690_) : new ItemStack((ItemLike)this.itemToEnchant);
        int amount = Mth.m_216271_((RandomSource)random, (int)this.minEnchantmentAmount, (int)this.maxEnchantmentAmount);
        for (int i = 0; i < amount; ++i) {
            Enchantment enchantment = this.enchantments.get(random.m_188503_(this.enchantments.size()));
            int level = Mth.m_216271_((RandomSource)random, (int)enchantment.m_44702_(), (int)enchantment.m_6586_());
            if (result.m_150930_(Items.f_42690_)) {
                EnchantmentInstance enchantmentInstance = new EnchantmentInstance(enchantment, level);
                EnchantedBookItem.m_41153_((ItemStack)result, (EnchantmentInstance)enchantmentInstance);
                continue;
            }
            result.m_41663_(enchantment, level);
        }
        return this.createOffer(result, random);
    }
}

