/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.features.enchantment.EnchantmentMenuProcess;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableEventJS;
import com.almostreliable.morejs.features.villager.IntRange;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EnchantmentTableServerEventJS
extends EnchantmentTableEventJS {
    protected final EnchantmentMenuProcess state;
    private final BlockPos pos;
    private boolean itemChanged;

    public EnchantmentTableServerEventJS(ItemStack item, ItemStack secondItem, Level level, BlockPos pos, Player player, EnchantmentMenuProcess state) {
        super(item, secondItem, level, player, state.getMenu());
        this.pos = pos;
        this.state = state;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public Data get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getSize());
        return new Data(index);
    }

    public int getSize() {
        return this.state.getMenu().f_39446_.length;
    }

    public void setItem(ItemStack item) {
        this.itemChanged = true;
        this.item = item;
    }

    public boolean itemWasChanged() {
        return this.itemChanged;
    }

    public class Data {
        protected final int index;

        protected Data(int index) {
            this.index = index;
        }

        public int getRequiredLevel() {
            return EnchantmentTableServerEventJS.this.menu.f_39446_[this.index];
        }

        public int getEnchantmentCount() {
            return this.getEnchantments().size();
        }

        public void forEachEnchantments(BiConsumer<Enchantment, Integer> consumer) {
            this.getEnchantments().forEach(i -> consumer.accept(i.f_44947_, i.f_44948_));
        }

        public void clearEnchantments() {
            this.getEnchantments().clear();
        }

        public List<ResourceLocation> getEnchantmentIds() {
            return this.getEnchantments().stream().map(e -> BuiltInRegistries.f_256876_.m_7981_((Object)e.f_44947_)).filter(Objects::nonNull).toList();
        }

        public boolean hasEnchantment(ResourceLocation id) {
            return this.hasEnchantment(id, IntRange.all());
        }

        public boolean hasEnchantment(ResourceLocation id, IntRange range) {
            Enchantment enchantment = BuiltInRegistries.f_256876_.m_6612_(id).orElse(null);
            if (enchantment == null) {
                return false;
            }
            for (EnchantmentInstance enchantmentInstance : this.getEnchantments()) {
                if (enchantmentInstance.f_44947_ != enchantment || !range.test(enchantmentInstance.f_44948_)) continue;
                return true;
            }
            return false;
        }

        protected List<EnchantmentInstance> getEnchantments() {
            return EnchantmentTableServerEventJS.this.state.getEnchantments(this.index);
        }
    }
}

