/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells;

import appeng.api.client.StorageCellModels;
import appeng.api.networking.GridServices;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.client.render.crafting.CraftingMonitorRenderer;
import appeng.core.definitions.ItemDefinition;
import appeng.hotkeys.HotkeyActions;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.AbstractPortableCell;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.core.Platform;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.appbot.AppBotItems;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.DecompressionService;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MEGACells {
    public static final String MODID = "megacells";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MEGA Cells");
    public static final Platform PLATFORM = ServiceLoader.load(Platform.class).findFirst().orElseThrow();

    private MEGACells() {
    }

    public static ResourceLocation makeId(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void initCommon() {
        PLATFORM.initItems();
        PLATFORM.register();
        PLATFORM.initUpgrades();
        StorageCells.addCellHandler((ICellHandler)BulkCellItem.HANDLER);
        MEGAItems.getItemPortables().forEach(cell -> HotkeyActions.registerPortableCell((ItemDefinition)cell, (String)"portable_item_cell"));
        MEGAItems.getFluidPortables().forEach(cell -> HotkeyActions.registerPortableCell((ItemDefinition)cell, (String)"portable_fluid_cell"));
        PLATFORM.initCompression();
        GridServices.register(DecompressionService.class, DecompressionService.class);
        PLATFORM.initLavaTransform();
        PLATFORM.addVillagerTrade((ItemLike)MEGAItems.SKY_STEEL_INGOT, 8, 3, 20);
        PLATFORM.addVillagerTrade((ItemLike)MEGAItems.ACCUMULATION_PROCESSOR_PRESS, 40, 1, 50);
    }

    public static class Client {
        public static final Platform.Client PLATFORM = ServiceLoader.load(Platform.Client.class).findFirst().orElseThrow();

        private Client() {
        }

        public static void initClient() {
            PLATFORM.initScreens();
            PLATFORM.initEnergyCellProps();
            PLATFORM.initCraftingUnitModels();
            Stream.of(MEGAItems.getItemCells(), MEGAItems.getItemPortables()).flatMap(Collection::stream).forEach(c -> StorageCellModels.registerModel((ItemLike)c, (ResourceLocation)MEGACells.makeId("block/drive/cells/mega_item_cell")));
            Stream.of(MEGAItems.getFluidCells(), MEGAItems.getFluidPortables()).flatMap(Collection::stream).forEach(c -> StorageCellModels.registerModel((ItemLike)c, (ResourceLocation)MEGACells.makeId("block/drive/cells/mega_fluid_cell")));
            StorageCellModels.registerModel(MEGAItems.BULK_ITEM_CELL, (ResourceLocation)MEGACells.makeId("block/drive/cells/bulk_item_cell"));
            if (PLATFORM.isAddonLoaded(Addons.APPBOT)) {
                Stream.of(AppBotItems.getCells(), AppBotItems.getPortables()).flatMap(Collection::stream).forEach(c -> StorageCellModels.registerModel((ItemLike)c, (ResourceLocation)MEGACells.makeId("block/drive/cells/mega_mana_cell")));
            }
            BlockEntityRenderers.m_173590_(MEGABlockEntities.MEGA_CRAFTING_MONITOR, CraftingMonitorRenderer::new);
            PLATFORM.initItemColours(BasicStorageCell::getColor, PLATFORM.getAllCells());
            PLATFORM.initItemColours(AbstractPortableCell::getColor, PLATFORM.getAllPortables());
        }
    }
}

