/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.mixins;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.helpers.patternprovider.PatternProviderReturnInventory;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.helpers.patternprovider.UnlockCraftingEvent;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import stone.mae2.MAE2;
import stone.mae2.appeng.helpers.patternprovider.PatternProviderTargetCache;
import stone.mae2.parts.p2p.PatternP2PTunnel;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public abstract class PatternProviderLogicMixin {
    @Shadow
    private PatternProviderLogicHost host;
    @Shadow
    private IManagedGridNode mainNode;
    @Shadow
    private IActionSource actionSource;
    @Shadow
    private ConfigManager configManager;
    @Shadow
    private int priority;
    @Shadow
    private AppEngInternalInventory patternInventory;
    @Shadow
    private List<IPatternDetails> patterns;
    @Shadow
    private Set<AEKey> patternInputs;
    @Shadow
    private List<GenericStack> sendList;
    @Shadow
    private Direction sendDirection;
    @Shadow
    private PatternProviderReturnInventory returnInv;
    @Shadow
    private YesNo redstoneState;
    @Shadow
    @Nullable
    private UnlockCraftingEvent unlockEvent;
    @Shadow
    @Nullable
    private GenericStack unlockStack;
    @Shadow
    private int roundRobinIndex;
    private BlockPos sendPos;
    private PatternProviderTargetCache cache;
    private static final String SEND_POS_TAG = "sendPos";

    @Overwrite
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.sendList.isEmpty() && this.mainNode.isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        BlockEntity be = this.host.getBlockEntity();
        Level level = be.m_58904_();
        if (this.getCraftingLockedReason() != LockCraftingMode.NONE) {
            return false;
        }
        if (!patternDetails.supportsPushInputsToExternalInventory()) {
            for (Direction direction : this.getActiveSides()) {
                Direction adjBeSide = direction.m_122424_();
                List<PatternP2PTunnel.TunneledPos> positions = this.getTunneledPositions(be.m_58899_().m_121945_(direction), level, adjBeSide);
                if (positions == null) continue;
                for (PatternP2PTunnel.TunneledPos adjPos : positions) {
                    BlockEntity adjBe = level.m_7702_(adjPos.pos());
                    ICraftingMachine craftingMachine = ICraftingMachine.of((Level)level, (BlockPos)adjPos.pos(), (Direction)adjPos.dir(), (BlockEntity)adjBe);
                    if (craftingMachine == null || !craftingMachine.acceptsPlans() || !craftingMachine.pushPattern(patternDetails, inputHolder, adjPos.dir())) continue;
                    this.onPushPatternSuccess(patternDetails);
                    return true;
                }
            }
        } else {
            ArrayList<PatternP2PTunnel.TunneledPatternProviderTarget> adapters = new ArrayList<PatternP2PTunnel.TunneledPatternProviderTarget>();
            for (Direction direction : this.getActiveSides()) {
                this.findAdapters(be, level, adapters, direction);
            }
            this.rearrangeRoundRobin(adapters);
            for (PatternP2PTunnel.TunneledPatternProviderTarget adapter : adapters) {
                PatternProviderTargetCache targetCache = adapter.target();
                PatternProviderTarget target = targetCache == null ? this.findAdapter(adapter.pos().dir()) : targetCache.find();
                if (target == null || this.isBlocking() && target.containsPatternInput(this.patternInputs) || !this.adapterAcceptsAll(target, inputHolder)) continue;
                patternDetails.pushInputsToExternalInventory(inputHolder, (what, amount) -> {
                    long inserted = target.insert(what, amount, Actionable.MODULATE);
                    if (inserted < amount) {
                        this.addToSendList(what, amount - inserted);
                    }
                });
                this.onPushPatternSuccess(patternDetails);
                this.sendPos = targetCache == null ? null : adapter.pos().pos();
                this.sendDirection = adapter.pos().dir();
                this.cache = targetCache;
                ++this.roundRobinIndex;
                return true;
            }
        }
        return false;
    }

    private void findAdapters(BlockEntity be, Level level, List<PatternP2PTunnel.TunneledPatternProviderTarget> adapters, Direction direction) {
        BlockEntity potentialPart = level.m_7702_(be.m_58899_().m_121945_(direction));
        if (potentialPart == null || !(potentialPart instanceof IPartHost)) {
            adapters.add(new PatternP2PTunnel.TunneledPatternProviderTarget(null, new PatternP2PTunnel.TunneledPos(be.m_58899_(), direction)));
        } else {
            IPart potentialTunnel = ((IPartHost)potentialPart).getPart(direction.m_122424_());
            if (potentialTunnel != null && potentialTunnel instanceof PatternP2PTunnel) {
                List<PatternP2PTunnel.TunneledPatternProviderTarget> newTargets = ((PatternP2PTunnel)potentialTunnel).getTargets();
                if (newTargets != null) {
                    adapters.addAll(newTargets);
                }
            } else {
                adapters.add(new PatternP2PTunnel.TunneledPatternProviderTarget(null, new PatternP2PTunnel.TunneledPos(be.m_58899_(), direction)));
            }
        }
    }

    private boolean sendStacksOut(PatternProviderTarget adapter) {
        if (adapter == null) {
            return false;
        }
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            long amount;
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long inserted = adapter.insert(what, amount = stack.amount(), Actionable.MODULATE);
            if (inserted >= amount) {
                it.remove();
                return true;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            return true;
        }
        if (this.sendList.isEmpty()) {
            this.sendPos = null;
        }
        return false;
    }

    @Overwrite
    private boolean sendStacksOut() {
        if (this.sendDirection == null) {
            if (!this.sendList.isEmpty()) {
                throw new IllegalStateException("Invalid pattern provider state, this is a bug.");
            }
            return false;
        }
        if (this.cache == null) {
            if (this.sendPos == null) {
                return this.sendStacksOut(this.findAdapter(this.sendDirection));
            }
            this.cache = this.findCache(this.sendPos, this.sendDirection);
        }
        return this.sendStacksOut(this.cache.find());
    }

    private List<PatternP2PTunnel.TunneledPos> getTunneledPositions(BlockPos pos, Level level, Direction adjBeSide) {
        BlockEntity potentialPart = level.m_7702_(pos);
        if (potentialPart == null || !(potentialPart instanceof IPartHost)) {
            return List.of(new PatternP2PTunnel.TunneledPos(pos, adjBeSide));
        }
        IPart potentialTunnel = ((IPartHost)potentialPart).getPart(adjBeSide);
        if (potentialTunnel instanceof PatternP2PTunnel) {
            PatternP2PTunnel tunnel = (PatternP2PTunnel)potentialTunnel;
            return tunnel.getTunneledPositions();
        }
        return List.of(new PatternP2PTunnel.TunneledPos(pos, adjBeSide));
    }

    @Nullable
    private PatternProviderTargetCache findCache(BlockPos pos, Direction dir) {
        BlockEntity thisBe = this.host.getBlockEntity();
        return new PatternProviderTargetCache((ServerLevel)thisBe.m_58904_(), pos, dir, this.actionSource);
    }

    @Shadow
    private PatternProviderTarget findAdapter(Direction side) {
        throw new RuntimeException("HOW, HOW DID YOU LOAD THIS!");
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void onWriteToNBT(CompoundTag tag, CallbackInfo ci) {
        if (this.sendPos != null) {
            tag.m_128356_(SEND_POS_TAG, this.sendPos.m_121878_());
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void onReadFromNBT(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_(SEND_POS_TAG)) {
            Tag sendPosTag = tag.m_128423_(SEND_POS_TAG);
            if (sendPosTag instanceof NumericTag) {
                NumericTag numericTag = (NumericTag)sendPosTag;
                this.sendPos = BlockPos.m_122022_((long)numericTag.m_7046_());
            } else if (sendPosTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)sendPosTag;
                MAE2.LOGGER.debug("Migrated Pattern Provider from MAE2 1.2.0!");
                PatternP2PTunnel.TunneledPos tunnelPos = PatternP2PTunnel.TunneledPos.readFromNBT(compoundTag);
                this.sendPos = tunnelPos.pos();
                this.sendDirection = tunnelPos.dir();
            }
        }
    }

    @Shadow
    private <T> void rearrangeRoundRobin(List<T> list) {
    }

    @Shadow
    public abstract boolean isBlocking();

    @Shadow
    private boolean adapterAcceptsAll(PatternProviderTarget adapter, KeyCounter[] inputHolder) {
        return false;
    }

    @Shadow
    private void addToSendList(AEKey what, long l) {
    }

    @Shadow
    private void onPushPatternSuccess(IPatternDetails patternDetails) {
    }

    @Shadow
    private Set<Direction> getActiveSides() {
        return null;
    }

    @Shadow
    public abstract LockCraftingMode getCraftingLockedReason();
}

