/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.integration;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.core.localization.InGameTooltip;
import appeng.util.Platform;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import stone.mae2.parts.p2p.multi.MultiP2PTunnelPart;
import stone.mae2.util.TransHelper;

public final class MultiP2PStateDataProvider
implements BodyProvider<MultiP2PTunnelPart>,
ServerDataProvider<MultiP2PTunnelPart> {
    private static final byte STATE_UNLINKED = 0;
    private static final byte STATE_OUTPUT = 1;
    private static final byte STATE_INPUT = 2;
    public static final String TAG_P2P_STATE = "p2pState";
    public static final String TAG_P2P_LINKS = "p2pLinks";
    public static final String TAG_P2P_FREQUENCY = "p2pFrequency";
    public static final String TAG_P2P_FREQUENCY_NAME = "p2pFrequencyName";

    public void buildTooltip(MultiP2PTunnelPart object, TooltipContext context, TooltipBuilder tooltip) {
        CompoundTag serverData = context.serverData();
        if (serverData.m_128425_(TAG_P2P_STATE, 1)) {
            byte state = serverData.m_128445_(TAG_P2P_STATE);
            int links = serverData.m_128451_(TAG_P2P_LINKS);
            switch (state) {
                case 0: {
                    tooltip.addLine((Component)InGameTooltip.P2PUnlinked.text());
                    break;
                }
                case 1: 
                case 2: {
                    tooltip.addLine(MultiP2PStateDataProvider.getLinkText(state == 2, links));
                }
            }
            short freq = serverData.m_128448_(TAG_P2P_FREQUENCY);
            Object freqTooltip = Platform.p2p().toHexString(freq);
            if (serverData.m_128425_(TAG_P2P_FREQUENCY_NAME, 8)) {
                String freqName = serverData.m_128461_(TAG_P2P_FREQUENCY_NAME);
                freqTooltip = freqName + " (" + (String)freqTooltip + ")";
            }
            tooltip.addLine((Component)InGameTooltip.P2PFrequency.text(new Object[]{freqTooltip}));
        }
    }

    public void provideServerData(Player player, MultiP2PTunnelPart part, CompoundTag serverData) {
        if (!part.isPowered()) {
            return;
        }
        serverData.m_128376_(TAG_P2P_FREQUENCY, part.getFrequency());
        byte state = 0;
        if (!part.isOutput()) {
            int outputCount = part.getOutputs().size();
            if (outputCount > 0) {
                state = 2;
                serverData.m_128405_(TAG_P2P_LINKS, outputCount);
            }
        } else {
            int inputCount = part.getInputs().size();
            if (inputCount > 0) {
                state = 1;
                serverData.m_128405_(TAG_P2P_LINKS, inputCount);
            }
        }
        serverData.m_128344_(TAG_P2P_STATE, state);
    }

    private static Component getLinkText(boolean isInput, int links) {
        if (isInput) {
            if (links > 1) {
                return InGameTooltip.P2PInputManyOutputs.text(new Object[]{links});
            }
            return InGameTooltip.P2PInputOneOutput.text();
        }
        if (links > 1) {
            return Component.m_264642_((String)TransHelper.WAILA.toKey("P2POutputManyInputs"), (String)"Linked (Output Side) - %s Inputs", (Object[])new Object[]{links});
        }
        return InGameTooltip.P2POutput.text();
    }
}

