/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import stone.mae2.MAE2;
import stone.mae2.parts.p2p.multi.MultiP2PTunnelPart;

public class RedstoneMultiP2PPart
extends MultiP2PTunnelPart<RedstoneMultiP2PPart> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_redstone"));
    private int power;
    private boolean recursive = false;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public RedstoneMultiP2PPart(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 0.5f;
    }

    private void setNetworkReady() {
        if (this.isOutput()) {
            this.putInput(this.getInputPower());
        }
    }

    private void putInput(int newPower) {
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.isOutput()) {
            if (this.getMainNode().isActive()) {
                if (this.power != newPower) {
                    this.power = newPower;
                    this.notifyNeighbors();
                }
            } else if (this.power != 0) {
                this.power = 0;
                this.notifyNeighbors();
            }
        }
        this.recursive = false;
    }

    private void notifyNeighbors() {
        Level level = this.getBlockEntity().m_58904_();
        Platform.notifyBlocksOfNeighbors((Level)level, (BlockPos)this.getBlockEntity().m_58899_());
        for (Direction face : Direction.values()) {
            Platform.notifyBlocksOfNeighbors((Level)level, (BlockPos)this.getBlockEntity().m_58899_().m_121945_(face));
        }
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (this.getMainNode().hasGridBooted()) {
            this.setNetworkReady();
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.power = tag.m_128451_("power");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128405_("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (!this.isOutput()) {
            BlockPos target = this.getBlockEntity().m_58899_().m_121945_(this.getSide());
            BlockState state = this.getBlockEntity().m_58904_().m_8055_(target);
            Block b = state.m_60734_();
            if (b != null) {
                int newInputPower;
                Direction srcSide = this.getSide();
                if (b instanceof RedStoneWireBlock) {
                    srcSide = Direction.UP;
                }
                int oldInputPower = this.getInputPower();
                int oldPower = this.power;
                this.power = b.m_6378_(state, (BlockGetter)this.getBlockEntity().m_58904_(), target, srcSide);
                if (oldInputPower == oldPower && oldPower != this.power && (newInputPower = this.getInputPower()) != oldInputPower) {
                    this.sendToOutput(newInputPower);
                }
            }
        }
    }

    public int getInputPower() {
        return this.getInputStream().mapToInt(in -> in.power).max().orElse(0);
    }

    public boolean canConnectRedstone() {
        return true;
    }

    public int isProvidingStrongPower() {
        return this.isOutput() ? this.power : 0;
    }

    public int isProvidingWeakPower() {
        return this.isOutput() ? this.power : 0;
    }

    private void sendToOutput(int power) {
        for (RedstoneMultiP2PPart rs : this.getOutputs()) {
            rs.putInput(power);
        }
    }

    public int getPower() {
        return this.power;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

