/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import java.util.List;
import net.minecraft.core.Direction;
import stone.mae2.MAE2;
import stone.mae2.parts.p2p.multi.CapabilityMultiP2PPart;

public class EUMultiP2PPart
extends CapabilityMultiP2PPart<EUMultiP2PPart, IEnergyContainer> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_eu"));
    private static final IEnergyContainer EMPTY_HANDLER = new EmptyHandler();

    public EUMultiP2PPart(IPartItem<?> partItem) {
        super(partItem, GTCapability.CAPABILITY_ENERGY_CONTAINER);
        this.inputHandler = new InputHandler();
        this.outputHandler = new OutputHandler();
        this.emptyHandler = EMPTY_HANDLER;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public class InputHandler
    implements IEnergyContainer {
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            int total = 0;
            int outputTunnels = EUMultiP2PPart.this.getOutputs().size();
            if (outputTunnels == 0 | voltage == 0L) {
                return 0L;
            }
            long toSend = voltage;
            for (EUMultiP2PPart target : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    IEnergyContainer output = (IEnergyContainer)capabilityGuard.get();
                    long received = output.acceptEnergyFromNetwork(target.getSide().m_122424_(), toSend, amperage);
                    total = (int)((long)total + received);
                    if ((toSend -= received) != 0L) continue;
                    break;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            EUMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, FeCompat.toFeBounded((long)((long)total * amperage), (int)FeCompat.ratio((boolean)false), (int)Integer.MAX_VALUE));
            return total;
        }

        public boolean inputsEnergy(Direction side) {
            return EUMultiP2PPart.this.getSide() == side;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyStored());
                    }
                    catch (ArithmeticException e) {
                        long l = 0L;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getEnergyCapacity() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyCapacity());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputAmperage() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getInputAmperage());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputVoltage() {
            long maxVoltage = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    maxVoltage = Math.max(maxVoltage, ((IEnergyContainer)guard.get()).getInputVoltage());
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return maxVoltage;
        }
    }

    public class OutputHandler
    implements IEnergyContainer {
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        public boolean inputsEnergy(Direction side) {
            return false;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getInputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyStored());
                    }
                    catch (ArithmeticException e) {
                        long l = 0L;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getEnergyCapacity() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getInputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyCapacity());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }

    private static class EmptyHandler
    implements IEnergyContainer {
        private EmptyHandler() {
        }

        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        public boolean inputsEnergy(Direction side) {
            return false;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            return 0L;
        }

        public long getEnergyCapacity() {
            return 0L;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }
}

